/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.filtering.HatchFilter;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.gnss.MeasurementType;

public class SingleFrequencyHatchFilter
extends HatchFilter {
    private final double integrationTime;
    private final double wavelength;
    private final SmoothingMeasurement smoothing;

    public SingleFrequencyHatchFilter(ObservationData initCode, ObservationData initSmoothing, MeasurementType type, double wavelength, double threshold, int N, double integrationTime) {
        super(threshold, N);
        this.wavelength = wavelength;
        this.integrationTime = integrationTime;
        this.smoothing = SmoothingMeasurement.getSmoothingMeasurement(type);
        this.updatePreviousSmoothedCode(initCode.getValue());
        this.updatePreviousSmoothingValue(this.smoothing.getSmoothingValue(wavelength, integrationTime, initSmoothing.getValue()));
        this.addToSmoothedCodeHistory(initCode.getValue());
        this.addToCodeHistory(initCode.getValue());
    }

    public ObservationData filterData(ObservationData codeData, ObservationData smoothingData) {
        double code = codeData.getValue();
        this.addToCodeHistory(code);
        double smoothingValue = this.smoothing.getSmoothingValue(this.wavelength, this.integrationTime, smoothingData.getValue());
        boolean cycleSlip = FastMath.floorMod((int)smoothingData.getLossOfLockIndicator(), (int)2) != 0;
        double smoothedValue = this.smoothedCode(code, smoothingValue);
        this.updatePreviousSmoothingValue(smoothingValue * (double)this.smoothing.getSign());
        smoothedValue = this.checkValidData(code, smoothedValue, cycleSlip);
        this.addToSmoothedCodeHistory(smoothedValue);
        this.updatePreviousSmoothedCode(smoothedValue);
        return new ObservationData(codeData.getObservationType(), smoothedValue, codeData.getLossOfLockIndicator(), codeData.getSignalStrength());
    }

    private static enum SmoothingMeasurement {
        CARRIER_PHASE(MeasurementType.CARRIER_PHASE){

            @Override
            public double getSmoothingValue(double lambda, double time, double value) {
                return lambda * value;
            }

            @Override
            public int getSign() {
                return 1;
            }
        }
        ,
        DOPPLER(MeasurementType.DOPPLER){

            @Override
            public double getSmoothingValue(double lambda, double time, double value) {
                return 0.5 * time * lambda * value;
            }

            @Override
            public int getSign() {
                return -1;
            }
        };

        private static final Map<MeasurementType, SmoothingMeasurement> KEYS_MAP;
        private final MeasurementType type;

        private SmoothingMeasurement(MeasurementType type) {
            this.type = type;
        }

        public abstract double getSmoothingValue(double var1, double var3, double var5);

        public abstract int getSign();

        public static SmoothingMeasurement getSmoothingMeasurement(MeasurementType type) {
            return KEYS_MAP.get((Object)type);
        }

        public MeasurementType getType() {
            return this.type;
        }

        static {
            KEYS_MAP = new HashMap<MeasurementType, SmoothingMeasurement>();
            for (SmoothingMeasurement measurement : SmoothingMeasurement.values()) {
                KEYS_MAP.put(measurement.getType(), measurement);
            }
        }
    }
}

