/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.orekit.estimation.measurements.filtering.DualFrequencyHatchFilter;
import org.orekit.estimation.measurements.filtering.SmoothedObservationDataSet;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.ChronologicalComparator;

public class DualFrequencySmoother {
    private int N;
    private double threshold;
    private HashMap<ObservationType, DualFrequencyHatchFilter> mapFilters;
    private HashMap<ObservationType, List<SmoothedObservationDataSet>> mapFilteredData = new HashMap();

    public DualFrequencySmoother(double threshold, int N) {
        this.mapFilters = new HashMap();
        this.N = N;
        this.threshold = threshold;
    }

    public DualFrequencyHatchFilter createFilter(ObservationData codeData, ObservationData phaseDataF1, ObservationData phaseDataF2, SatelliteSystem satSystem) {
        double wavelengthF1 = phaseDataF1.getObservationType().getFrequency(satSystem).getWavelength();
        double wavelengthF2 = phaseDataF2.getObservationType().getFrequency(satSystem).getWavelength();
        return new DualFrequencyHatchFilter(codeData, phaseDataF1, phaseDataF2, wavelengthF1, wavelengthF2, this.threshold, this.N);
    }

    public HashMap<ObservationType, List<SmoothedObservationDataSet>> getFilteredDataMap() {
        return this.mapFilteredData;
    }

    public final HashMap<ObservationType, DualFrequencyHatchFilter> getMapFilters() {
        return this.mapFilters;
    }

    public ObservationData copyObservationData(ObservationData obsData) {
        return new ObservationData(obsData.getObservationType(), obsData.getValue(), obsData.getLossOfLockIndicator(), obsData.getSignalStrength());
    }

    public void filterDataSet(List<ObservationDataSet> listODS, SatelliteSystem satSystem, int prnNumber, ObservationType obsTypeF1, ObservationType obsTypeF2) {
        ArrayList<ObservationDataSet> sortedListODS = new ArrayList<ObservationDataSet>(listODS);
        sortedListODS.sort(new ChronologicalComparator());
        for (ObservationDataSet obsSet : sortedListODS) {
            if (obsSet.getSatellite().getSystem() != satSystem || obsSet.getSatellite().getPRN() != prnNumber) continue;
            List<ObservationData> listObsData = obsSet.getObservationData();
            for (ObservationData obsData : listObsData) {
                ObservationType obsTypeRange;
                double snr = obsData.getSignalStrength();
                if (Double.isNaN(obsData.getValue()) || snr != 0.0 && !(snr >= 4.0) || (obsTypeRange = obsData.getObservationType()).getMeasurementType() != MeasurementType.PSEUDO_RANGE) continue;
                ObservationData obsDataPhaseF1 = null;
                ObservationData obsDataPhaseF2 = null;
                for (ObservationData obsDataPhase : listObsData) {
                    ObservationType obsTypePhase = obsDataPhase.getObservationType();
                    if (!Double.isNaN(obsDataPhase.getValue()) && obsTypePhase == obsTypeF1) {
                        obsDataPhaseF1 = this.copyObservationData(obsDataPhase);
                    }
                    if (Double.isNaN(obsDataPhase.getValue()) || obsTypePhase != obsTypeF2) continue;
                    obsDataPhaseF2 = this.copyObservationData(obsDataPhase);
                }
                DualFrequencyHatchFilter filterObject = this.mapFilters.get((Object)obsTypeRange);
                if (filterObject == null && obsDataPhaseF1 != null && obsDataPhaseF2 != null) {
                    filterObject = this.createFilter(obsData, obsDataPhaseF1, obsDataPhaseF2, satSystem);
                    this.mapFilters.put(obsTypeRange, filterObject);
                    ArrayList<SmoothedObservationDataSet> odList = new ArrayList<SmoothedObservationDataSet>();
                    odList.add(new SmoothedObservationDataSet(obsData, obsSet));
                    this.mapFilteredData.put(obsTypeRange, odList);
                    continue;
                }
                if (filterObject == null) continue;
                if (obsDataPhaseF1 == null || obsDataPhaseF2 == null) {
                    filterObject.resetFilterNext(obsData.getValue());
                    continue;
                }
                ObservationData filteredRange = filterObject.filterData(obsData, obsDataPhaseF1, obsDataPhaseF2);
                this.mapFilteredData.get((Object)obsTypeRange).add(new SmoothedObservationDataSet(filteredRange, obsSet));
            }
        }
    }
}

