/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TurnAroundRange
extends GroundReceiverMeasurement<TurnAroundRange> {
    public static final String MEASUREMENT_TYPE = "TurnAroundRange";
    private final GroundStation secondaryStation;

    public TurnAroundRange(GroundStation primaryStation, GroundStation secondaryStation, AbsoluteDate date, double turnAroundRange, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(primaryStation, true, date, turnAroundRange, sigma, baseWeight, satellite);
        this.addParameterDriver(secondaryStation.getEastOffsetDriver());
        this.addParameterDriver(secondaryStation.getNorthOffsetDriver());
        this.addParameterDriver(secondaryStation.getZenithOffsetDriver());
        this.addParameterDriver(secondaryStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(secondaryStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(secondaryStation.getPolarOffsetXDriver());
        this.addParameterDriver(secondaryStation.getPolarDriftXDriver());
        this.addParameterDriver(secondaryStation.getPolarOffsetYDriver());
        this.addParameterDriver(secondaryStation.getPolarDriftYDriver());
        this.secondaryStation = secondaryStation;
    }

    public GroundStation getPrimaryStation() {
        return this.getStation();
    }

    public GroundStation getSecondaryStation() {
        return this.secondaryStation;
    }

    @Override
    protected EstimatedMeasurementBase<TurnAroundRange> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        TimeStampedPVCoordinates pva = state.getPVCoordinates();
        double delta = this.getDate().durationFrom(state.getDate());
        Transform primaryToInert = this.getStation().getOffsetToInertial(state.getFrame(), this.getDate(), false);
        AbsoluteDate measurementDate = primaryToInert.getDate();
        TimeStampedPVCoordinates primaryArrival = primaryToInert.transformPVCoordinates(new TimeStampedPVCoordinates(measurementDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double primaryTauD = TurnAroundRange.signalTimeOfFlight(pva, primaryArrival.getPosition(), measurementDate, state.getFrame());
        double dtLeg2 = delta - primaryTauD;
        SpacecraftState transitStateLeg2 = state.shiftedBy(dtLeg2);
        TimeStampedPVCoordinates transitStateLeg2PV = pva.shiftedBy(dtLeg2);
        AbsoluteDate approxReboundDate = measurementDate.shiftedBy(-delta);
        Transform secondaryToInertApprox = this.secondaryStation.getOffsetToInertial(state.getFrame(), approxReboundDate, true);
        TimeStampedPVCoordinates QSecondaryApprox = secondaryToInertApprox.transformPVCoordinates(new TimeStampedPVCoordinates(approxReboundDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double secondaryTauU = TurnAroundRange.signalTimeOfFlight(QSecondaryApprox, transitStateLeg2PV.getPosition(), transitStateLeg2PV.getDate(), state.getFrame());
        double tauLeg2 = primaryTauD + secondaryTauU;
        AbsoluteDate reboundDate = measurementDate.shiftedBy(-tauLeg2);
        Transform secondaryToInert = this.secondaryStation.getOffsetToInertial(state.getFrame(), reboundDate, true);
        TimeStampedPVCoordinates secondaryRebound = secondaryToInert.transformPVCoordinates(new TimeStampedPVCoordinates(reboundDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double secondaryTauD = TurnAroundRange.signalTimeOfFlight(transitStateLeg2PV, secondaryRebound.getPosition(), reboundDate, state.getFrame());
        double dtLeg1 = dtLeg2 - secondaryTauU - secondaryTauD;
        TimeStampedPVCoordinates transitStateLeg1PV = pva.shiftedBy(dtLeg1);
        AbsoluteDate approxEmissionDate = measurementDate.shiftedBy(-2.0 * (secondaryTauU + primaryTauD));
        Transform primaryToInertApprox = this.getStation().getOffsetToInertial(state.getFrame(), approxEmissionDate, true);
        TimeStampedPVCoordinates QPrimaryApprox = primaryToInertApprox.transformPVCoordinates(new TimeStampedPVCoordinates(approxEmissionDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double primaryTauU = TurnAroundRange.signalTimeOfFlight(QPrimaryApprox, transitStateLeg1PV.getPosition(), transitStateLeg1PV.getDate(), state.getFrame());
        AbsoluteDate emissionDate = transitStateLeg1PV.getDate().shiftedBy(-primaryTauU);
        TimeStampedPVCoordinates primaryDeparture = primaryToInertApprox.shiftedBy(emissionDate.durationFrom(primaryToInertApprox.getDate())).transformPVCoordinates(new TimeStampedPVCoordinates(emissionDate, PVCoordinates.ZERO));
        double tauLeg1 = secondaryTauD + primaryTauU;
        EstimatedMeasurementBase<TurnAroundRange> estimated = new EstimatedMeasurementBase<TurnAroundRange>(this, iteration, evaluation, new SpacecraftState[]{transitStateLeg2.shiftedBy(-secondaryTauU)}, new TimeStampedPVCoordinates[]{primaryDeparture, transitStateLeg1PV, secondaryRebound, transitStateLeg2.getPVCoordinates(), primaryArrival});
        double cOver2 = 1.49896229E8;
        double turnAroundRange = (tauLeg2 + tauLeg1) * 1.49896229E8;
        estimated.setEstimatedValue(turnAroundRange);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<TurnAroundRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (indices.containsKey(span.getData())) continue;
                indices.put(span.getData(), nbParams++);
            }
        }
        GradientField field = GradientField.getField((int)nbParams);
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = TurnAroundRange.getCoordinates(state, 0, nbParams);
        double delta = this.getDate().durationFrom(state.getDate());
        FieldTransform<Gradient> primaryToInert = this.getStation().getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> measurementDateDS = primaryToInert.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> primaryArrival = primaryToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(measurementDateDS, zero, zero, zero));
        Gradient primaryTauD = TurnAroundRange.signalTimeOfFlight(pvaDS, primaryArrival.getPosition(), measurementDateDS, state.getFrame());
        Gradient dtLeg2 = (Gradient)primaryTauD.negate().add(delta);
        SpacecraftState transitStateLeg2 = state.shiftedBy(dtLeg2.getValue());
        FieldPVCoordinates transitStateLeg2PV = pvaDS.shiftedBy((CalculusFieldElement)dtLeg2);
        TimeShiftable approxReboundDate = measurementDateDS.shiftedBy(-delta);
        FieldTransform<Gradient> secondaryToInertApprox = this.secondaryStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxReboundDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QSecondaryApprox = secondaryToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxReboundDate, zero, zero, zero));
        Gradient secondaryTauU = TurnAroundRange.signalTimeOfFlight(QSecondaryApprox, transitStateLeg2PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg2PV).getDate(), state.getFrame());
        Gradient tauLeg2 = primaryTauD.add(secondaryTauU);
        FieldTimeShiftable reboundDateDS = measurementDateDS.shiftedBy((CalculusFieldElement)tauLeg2.negate());
        FieldTransform<Gradient> secondaryToInert = this.secondaryStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)reboundDateDS, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> secondaryRebound = secondaryToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates(reboundDateDS, FieldPVCoordinates.getZero(field)));
        Gradient secondaryTauD = (Gradient)TurnAroundRange.signalTimeOfFlight(transitStateLeg2PV, secondaryRebound.getPosition(), reboundDateDS, state.getFrame());
        Gradient dtLeg1 = dtLeg2.subtract(secondaryTauU).subtract(secondaryTauD);
        FieldPVCoordinates transitStateLeg1PV = pvaDS.shiftedBy((CalculusFieldElement)dtLeg1);
        TimeShiftable approxEmissionDate = measurementDateDS.shiftedBy(-2.0 * (secondaryTauU.getValue() + primaryTauD.getValue()));
        FieldTransform<Gradient> primaryToInertApprox = this.getStation().getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxEmissionDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QPrimaryApprox = primaryToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxEmissionDate, zero, zero, zero));
        Gradient primaryTauU = TurnAroundRange.signalTimeOfFlight(QPrimaryApprox, transitStateLeg1PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate(), state.getFrame());
        AbsoluteDate emissionDate = ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate().toAbsoluteDate().shiftedBy(-primaryTauU.getValue());
        TimeStampedPVCoordinates primaryDeparture = ((FieldTransform)primaryToInertApprox.shiftedBy(emissionDate.durationFrom(primaryToInertApprox.getDate()))).transformPVCoordinates(new TimeStampedPVCoordinates(emissionDate, PVCoordinates.ZERO)).toTimeStampedPVCoordinates();
        Gradient tauLeg1 = secondaryTauD.add(primaryTauU);
        EstimatedMeasurement<TurnAroundRange> estimated = new EstimatedMeasurement<TurnAroundRange>(this, iteration, evaluation, new SpacecraftState[]{transitStateLeg2.shiftedBy(-secondaryTauU.getValue())}, new TimeStampedPVCoordinates[]{primaryDeparture, ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).toTimeStampedPVCoordinates(), secondaryRebound.toTimeStampedPVCoordinates(), transitStateLeg2.getPVCoordinates(), primaryArrival.toTimeStampedPVCoordinates()});
        double cOver2 = 1.49896229E8;
        Gradient turnAroundRange = tauLeg2.add(tauLeg1).multiply(1.49896229E8);
        estimated.setEstimatedValue(turnAroundRange.getValue());
        double[] derivatives = turnAroundRange.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = (Integer)indices.get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

