/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TDOA
extends GroundReceiverMeasurement<TDOA> {
    public static final String MEASUREMENT_TYPE = "TDOA";
    private final GroundStation secondStation;

    public TDOA(GroundStation primeStation, GroundStation secondStation, AbsoluteDate date, double tdoa, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(primeStation, false, date, tdoa, sigma, baseWeight, satellite);
        this.addParameterDriver(secondStation.getClockOffsetDriver());
        this.addParameterDriver(secondStation.getEastOffsetDriver());
        this.addParameterDriver(secondStation.getNorthOffsetDriver());
        this.addParameterDriver(secondStation.getZenithOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(secondStation.getPolarOffsetXDriver());
        this.addParameterDriver(secondStation.getPolarDriftXDriver());
        this.addParameterDriver(secondStation.getPolarOffsetYDriver());
        this.addParameterDriver(secondStation.getPolarDriftYDriver());
        this.secondStation = secondStation;
    }

    public GroundStation getPrimeStation() {
        return this.getStation();
    }

    public GroundStation getSecondStation() {
        return this.secondStation;
    }

    @Override
    protected EstimatedMeasurementBase<TDOA> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates emitterPV = common.getTransitPV();
        AbsoluteDate emitterDate = emitterPV.getDate();
        Transform secondToInertial = this.getSecondStation().getOffsetToInertial(common.getState().getFrame(), emitterDate, true);
        TimeStampedPVCoordinates secondApprox = secondToInertial.transformPVCoordinates(new TimeStampedPVCoordinates(emitterDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double tau2 = TDOA.forwardSignalTimeOfFlight(secondApprox, emitterPV.getPosition(), emitterDate);
        TimeStampedPVCoordinates secondPV = secondApprox.shiftedBy(tau2);
        double offset1 = this.getPrimeStation().getClockOffsetDriver().getValue(emitterDate);
        double offset2 = this.getSecondStation().getClockOffsetDriver().getValue(emitterDate);
        double tdoa = common.getTauD() + offset1 - (tau2 + offset2);
        EstimatedMeasurement<TDOA> estimated = new EstimatedMeasurement<TDOA>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{emitterPV, tdoa > 0.0 ? secondPV : common.getStationDownlink(), tdoa > 0.0 ? common.getStationDownlink() : secondPV});
        estimated.setEstimatedValue(tdoa);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<TDOA> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> emitterPV = common.getTransitPV();
        FieldAbsoluteDate<Gradient> emitterDate = emitterPV.getDate();
        FieldVector3D zero = FieldVector3D.getZero((Field)common.getTauD().getField());
        FieldTransform<Gradient> secondToInertial = this.getSecondStation().getOffsetToInertial(state.getFrame(), emitterDate, nbParams, common.getIndices());
        TimeStampedFieldPVCoordinates<Gradient> secondApprox = secondToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(emitterDate, zero, zero, zero));
        Gradient tau2 = TDOA.forwardSignalTimeOfFlight(secondApprox, emitterPV.getPosition(), emitterDate);
        FieldPVCoordinates secondPV = secondApprox.shiftedBy((CalculusFieldElement)tau2);
        Gradient offset1 = this.getPrimeStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), emitterDate.toAbsoluteDate());
        Gradient offset2 = this.getSecondStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), emitterDate.toAbsoluteDate());
        Gradient tdoaG = common.getTauD().add(offset1).subtract(tau2.add(offset2));
        double tdoa = tdoaG.getValue();
        TimeStampedPVCoordinates pv1 = common.getStationDownlink().toTimeStampedPVCoordinates();
        TimeStampedPVCoordinates pv2 = ((TimeStampedFieldPVCoordinates)secondPV).toTimeStampedPVCoordinates();
        EstimatedMeasurement<TDOA> estimated = new EstimatedMeasurement<TDOA>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{emitterPV.toTimeStampedPVCoordinates(), tdoa > 0.0 ? pv2 : pv1, tdoa > 0.0 ? pv1 : pv2});
        estimated.setEstimatedValue(tdoa);
        double[] derivatives = tdoaG.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }

    public static double forwardSignalTimeOfFlight(TimeStampedPVCoordinates adjustableEmitterPV, Vector3D receiverPosition, AbsoluteDate signalArrivalDate) {
        double delta;
        double offset;
        double delay = offset = signalArrivalDate.durationFrom(adjustableEmitterPV.getDate());
        double cReciprocal = 3.3356409519815204E-9;
        int count = 0;
        do {
            double previous = delay;
            Vector3D transitP = adjustableEmitterPV.shiftedBy(delay - offset).getPosition();
            delay = receiverPosition.distance((Point)transitP) * 3.3356409519815204E-9;
            delta = FastMath.abs((double)(delay - previous));
        } while (count++ < 10 && delta >= 2.0 * FastMath.ulp((double)delay));
        return delay;
    }

    public static <T extends CalculusFieldElement<T>> T forwardSignalTimeOfFlight(TimeStampedFieldPVCoordinates<T> adjustableEmitterPV, FieldVector3D<T> receiverPosition, FieldAbsoluteDate<T> signalArrivalDate) {
        double delta;
        T offset;
        Object delay = offset = signalArrivalDate.durationFrom(adjustableEmitterPV.getDate());
        double cReciprocal = 3.3356409519815204E-9;
        int count = 0;
        do {
            double previous = delay.getReal();
            FieldVector3D transitP = adjustableEmitterPV.shiftedBy((CalculusFieldElement)delay.subtract(offset)).getPosition();
            delay = (CalculusFieldElement)receiverPosition.distance(transitP).multiply(3.3356409519815204E-9);
            delta = FastMath.abs((double)(delay.getReal() - previous));
        } while (count++ < 10 && delta >= 2.0 * FastMath.ulp((double)delay.getReal()));
        return delay;
    }
}

