/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class RangeRate
extends GroundReceiverMeasurement<RangeRate> {
    public static final String MEASUREMENT_TYPE = "RangeRate";

    public RangeRate(GroundStation station, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, boolean twoway, ObservableSatellite satellite) {
        super(station, twoway, date, rangeRate, sigma, baseWeight, satellite);
    }

    @Override
    protected EstimatedMeasurementBase<RangeRate> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        EstimatedMeasurementBase<RangeRate> estimated;
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitPV();
        EstimatedMeasurementBase<RangeRate> evalOneWay1 = this.oneWayTheoreticalEvaluation(iteration, evaluation, true, common.getStationDownlink(), transitPV, common.getTransitState());
        if (this.isTwoWay()) {
            Transform offsetToInertialApproxUplink = this.getStation().getOffsetToInertial(common.getState().getFrame(), common.getStationDownlink().getDate().shiftedBy(-2.0 * common.getTauD()), false);
            AbsoluteDate approxUplinkDate = offsetToInertialApproxUplink.getDate();
            TimeStampedPVCoordinates stationApproxUplink = offsetToInertialApproxUplink.transformPVCoordinates(new TimeStampedPVCoordinates(approxUplinkDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
            double tauU = RangeRate.signalTimeOfFlight(stationApproxUplink, transitPV.getPosition(), transitPV.getDate(), common.getState().getFrame());
            TimeStampedPVCoordinates stationUplink = stationApproxUplink.shiftedBy(transitPV.getDate().durationFrom(approxUplinkDate) - tauU);
            EstimatedMeasurementBase<RangeRate> evalOneWay2 = this.oneWayTheoreticalEvaluation(iteration, evaluation, false, stationUplink, transitPV, common.getTransitState());
            estimated = new EstimatedMeasurementBase<RangeRate>(this, iteration, evaluation, evalOneWay1.getStates(), new TimeStampedPVCoordinates[]{evalOneWay2.getParticipants()[0], evalOneWay1.getParticipants()[0], evalOneWay1.getParticipants()[1]});
            estimated.setEstimatedValue(0.5 * (evalOneWay1.getEstimatedValue()[0] + evalOneWay2.getEstimatedValue()[0]));
        } else {
            estimated = evalOneWay1;
        }
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<RangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        EstimatedMeasurement<RangeRate> estimated;
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        EstimatedMeasurement<RangeRate> evalOneWay1 = this.oneWayTheoreticalEvaluation(iteration, evaluation, true, common.getStationDownlink(), transitPV, common.getTransitState(), common.getIndices(), nbParams);
        if (this.isTwoWay()) {
            FieldTransform<Gradient> offsetToInertialApproxUplink = this.getStation().getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)common.getStationDownlink().getDate().shiftedBy((CalculusFieldElement)common.getTauD().multiply(-2)), nbParams, common.getIndices());
            FieldAbsoluteDate<Gradient> approxUplinkDateDS = offsetToInertialApproxUplink.getFieldDate();
            FieldVector3D zero = FieldVector3D.getZero((Field)common.getTauD().getField());
            TimeStampedFieldPVCoordinates<Gradient> stationApproxUplink = offsetToInertialApproxUplink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(approxUplinkDateDS, zero, zero, zero));
            Gradient tauU = RangeRate.signalTimeOfFlight(stationApproxUplink, transitPV.getPosition(), transitPV.getDate(), state.getFrame());
            FieldPVCoordinates stationUplink = stationApproxUplink.shiftedBy((CalculusFieldElement)transitPV.getDate().durationFrom(approxUplinkDateDS).subtract(tauU));
            EstimatedMeasurement<RangeRate> evalOneWay2 = this.oneWayTheoreticalEvaluation(iteration, evaluation, false, (TimeStampedFieldPVCoordinates<Gradient>)stationUplink, transitPV, common.getTransitState(), common.getIndices(), nbParams);
            estimated = new EstimatedMeasurement<RangeRate>(this, iteration, evaluation, evalOneWay1.getStates(), new TimeStampedPVCoordinates[]{evalOneWay2.getParticipants()[0], evalOneWay1.getParticipants()[0], evalOneWay1.getParticipants()[1]});
            estimated.setEstimatedValue(0.5 * (evalOneWay1.getEstimatedValue()[0] + evalOneWay2.getEstimatedValue()[0]));
            double[][] sd1 = evalOneWay1.getStateDerivatives(0);
            double[][] sd2 = evalOneWay2.getStateDerivatives(0);
            double[][] sd = new double[sd1.length][sd1[0].length];
            for (int i = 0; i < sd.length; ++i) {
                for (int j = 0; j < sd[0].length; ++j) {
                    sd[i][j] = 0.5 * (sd1[i][j] + sd2[i][j]);
                }
            }
            estimated.setStateDerivatives(0, sd);
            evalOneWay1.getDerivativesDrivers().forEach(driver -> {
                for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    double[] pd1 = evalOneWay1.getParameterDerivatives((ParameterDriver)driver, span.getStart());
                    double[] pd2 = evalOneWay2.getParameterDerivatives((ParameterDriver)driver, span.getStart());
                    double[] pd = new double[pd1.length];
                    for (int i = 0; i < pd.length; ++i) {
                        pd[i] = 0.5 * (pd1[i] + pd2[i]);
                    }
                    estimated.setParameterDerivatives((ParameterDriver)driver, span.getStart(), pd);
                }
            });
        } else {
            estimated = evalOneWay1;
        }
        return estimated;
    }

    private EstimatedMeasurementBase<RangeRate> oneWayTheoreticalEvaluation(int iteration, int evaluation, boolean downlink, TimeStampedPVCoordinates stationPV, TimeStampedPVCoordinates transitPV, SpacecraftState transitState) {
        double lineOfSightVelocity;
        EstimatedMeasurementBase<RangeRate> estimated = new EstimatedMeasurementBase<RangeRate>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{downlink ? transitPV : stationPV, downlink ? stationPV : transitPV});
        Vector3D stationPosition = stationPV.getPosition();
        Vector3D relativePosition = stationPosition.subtract((Vector)transitPV.getPosition());
        Vector3D stationVelocity = stationPV.getVelocity();
        Vector3D relativeVelocity = stationVelocity.subtract((Vector)transitPV.getVelocity());
        Vector3D lineOfSight = (Vector3D)relativePosition.normalize();
        double rangeRate = lineOfSightVelocity = Vector3D.dotProduct((Vector3D)relativeVelocity, (Vector3D)lineOfSight);
        if (!this.isTwoWay()) {
            ObservableSatellite satellite = this.getSatellites().get(0);
            double dtsDot = satellite.getClockDriftDriver().getValue(transitState.getDate());
            double dtgDot = this.getStation().getClockDriftDriver().getValue(stationPV.getDate());
            double clockDriftBiais = (dtgDot - dtsDot) * 2.99792458E8;
            rangeRate += clockDriftBiais;
        }
        estimated.setEstimatedValue(rangeRate);
        return estimated;
    }

    private EstimatedMeasurement<RangeRate> oneWayTheoreticalEvaluation(int iteration, int evaluation, boolean downlink, TimeStampedFieldPVCoordinates<Gradient> stationPV, TimeStampedFieldPVCoordinates<Gradient> transitPV, SpacecraftState transitState, Map<String, Integer> indices, int nbParams) {
        Gradient lineOfSightVelocity;
        EstimatedMeasurement<RangeRate> estimated = new EstimatedMeasurement<RangeRate>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{(downlink ? transitPV : stationPV).toTimeStampedPVCoordinates(), (downlink ? stationPV : transitPV).toTimeStampedPVCoordinates()});
        FieldVector3D stationPosition = stationPV.getPosition();
        FieldVector3D relativePosition = stationPosition.subtract(transitPV.getPosition());
        FieldVector3D stationVelocity = stationPV.getVelocity();
        FieldVector3D relativeVelocity = stationVelocity.subtract(transitPV.getVelocity());
        FieldVector3D lineOfSight = relativePosition.normalize();
        Gradient rangeRate = lineOfSightVelocity = (Gradient)FieldVector3D.dotProduct((FieldVector3D)relativeVelocity, (FieldVector3D)lineOfSight);
        if (!this.isTwoWay()) {
            ObservableSatellite satellite = this.getSatellites().get(0);
            Gradient dtsDot = satellite.getClockDriftDriver().getValue(nbParams, indices, transitState.getDate());
            Gradient dtgDot = this.getStation().getClockDriftDriver().getValue(nbParams, indices, stationPV.getDate().toAbsoluteDate());
            Gradient clockDriftBiais = dtgDot.subtract(dtsDot).multiply(2.99792458E8);
            rangeRate = rangeRate.add(clockDriftBiais);
        }
        estimated.setEstimatedValue(rangeRate.getValue());
        double[] derivatives = rangeRate.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = indices.get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

