/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Range
extends GroundReceiverMeasurement<Range> {
    public static final String MEASUREMENT_TYPE = "Range";

    public Range(GroundStation station, boolean twoWay, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(station, twoWay, date, range, sigma, baseWeight, satellite);
    }

    @Override
    protected EstimatedMeasurementBase<Range> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        double range;
        EstimatedMeasurementBase<Range> estimated;
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitState().getPVCoordinates();
        if (this.isTwoWay()) {
            TimeStampedPVCoordinates stationAtTransitDate = common.getStationDownlink().shiftedBy(-common.getTauD());
            double tauU = Range.signalTimeOfFlight(stationAtTransitDate, transitPV.getPosition(), transitPV.getDate(), common.getState().getFrame());
            TimeStampedPVCoordinates stationUplink = common.getStationDownlink().shiftedBy(-common.getTauD() - tauU);
            estimated = new EstimatedMeasurementBase<Range>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{stationUplink, transitPV, common.getStationDownlink()});
            double cOver2 = 1.49896229E8;
            double tau = common.getTauD() + tauU;
            range = tau * 1.49896229E8;
        } else {
            estimated = new EstimatedMeasurementBase<Range>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV, common.getStationDownlink()});
            ObservableSatellite satellite = this.getSatellites().get(0);
            double dts = satellite.getClockOffsetDriver().getValue(common.getState().getDate());
            double dtg = this.getStation().getClockOffsetDriver().getValue(common.getState().getDate());
            range = (common.getTauD() + dtg - dts) * 2.99792458E8;
        }
        estimated.setEstimatedValue(range);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<Range> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        Gradient range;
        EstimatedMeasurement<Range> estimated;
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        if (this.isTwoWay()) {
            FieldPVCoordinates stationAtTransitDate = common.getStationDownlink().shiftedBy((CalculusFieldElement)common.getTauD().negate());
            Gradient tauU = Range.signalTimeOfFlight(stationAtTransitDate, transitPV.getPosition(), transitPV.getDate(), state.getFrame());
            FieldPVCoordinates stationUplink = common.getStationDownlink().shiftedBy(-common.getTauD().getValue() - tauU.getValue());
            estimated = new EstimatedMeasurement<Range>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{((TimeStampedFieldPVCoordinates)stationUplink).toTimeStampedPVCoordinates(), transitPV.toTimeStampedPVCoordinates(), common.getStationDownlink().toTimeStampedPVCoordinates()});
            double cOver2 = 1.49896229E8;
            Gradient tau = common.getTauD().add(tauU);
            range = tau.multiply(1.49896229E8);
        } else {
            estimated = new EstimatedMeasurement<Range>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV.toTimeStampedPVCoordinates(), common.getStationDownlink().toTimeStampedPVCoordinates()});
            ObservableSatellite satellite = this.getSatellites().get(0);
            Gradient dts = satellite.getClockOffsetDriver().getValue(nbParams, common.getIndices(), state.getDate());
            Gradient dtg = this.getStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), state.getDate());
            range = common.getTauD().add(dtg).subtract(dts).multiply(2.99792458E8);
        }
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

