/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;

public class QuadraticFieldClockModel<T extends CalculusFieldElement<T>> {
    private final FieldAbsoluteDate<T> referenceDate;
    private final T a0;
    private final T a1;
    private final T a2;

    public QuadraticFieldClockModel(FieldAbsoluteDate<T> referenceDate, T a0, T a1, T a2) {
        this.referenceDate = referenceDate;
        this.a0 = a0;
        this.a1 = a1;
        this.a2 = a2;
    }

    public FieldClockOffset<T> getOffset(FieldAbsoluteDate<T> date) {
        T dt = date.durationFrom(this.referenceDate);
        return new FieldClockOffset<CalculusFieldElement>(date, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply(dt)).add(this.a1)).multiply(dt)).add(this.a0), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply(dt)).multiply(2)).add(this.a1), (CalculusFieldElement)this.a2.multiply(2));
    }
}

