/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.QuadraticFieldClockModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.ClockOffset;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;
import org.orekit.utils.ParameterDriver;

public class QuadraticClockModel
implements ClockModel {
    private static final double CLOCK_OFFSET_SCALE = FastMath.scalb((double)1.0, (int)-10);
    private final ParameterDriver a0;
    private final ParameterDriver a1;
    private final ParameterDriver a2;

    public QuadraticClockModel(AbsoluteDate referenceDate, double a0, double a1, double a2) {
        this(new ParameterDriver("a0", 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterDriver("a1", 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterDriver("a2", 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        this.a0.setValue(a0);
        this.a0.setReferenceDate(referenceDate);
        this.a1.setValue(a1);
        this.a1.setReferenceDate(referenceDate);
        this.a2.setValue(a2);
        this.a2.setReferenceDate(referenceDate);
    }

    public QuadraticClockModel(ParameterDriver a0, ParameterDriver a1, ParameterDriver a2) {
        this.a0 = a0;
        this.a1 = a1;
        this.a2 = a2;
    }

    @Override
    public AbsoluteDate getValidityStart() {
        return AbsoluteDate.PAST_INFINITY;
    }

    @Override
    public AbsoluteDate getValidityEnd() {
        return AbsoluteDate.FUTURE_INFINITY;
    }

    @Override
    public ClockOffset getOffset(AbsoluteDate date) {
        double dt = date.durationFrom(this.getSafeReference(date));
        double c0 = this.a0.getValue(date);
        double c1 = this.a1.getValue(date);
        double c2 = this.a2.getValue(date);
        return new ClockOffset(date, (c2 * dt + c1) * dt + c0, 2.0 * c2 * dt + c1, 2.0 * c2);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldClockOffset<T> getOffset(FieldAbsoluteDate<T> date) {
        AbsoluteDate aDate = date.toAbsoluteDate();
        T dt = date.durationFrom(this.getSafeReference(aDate));
        double c0 = this.a0.getValue(aDate);
        double c1 = this.a1.getValue(aDate);
        double c2 = this.a2.getValue(aDate);
        return new FieldClockOffset<CalculusFieldElement>(date, (CalculusFieldElement)((CalculusFieldElement)dt.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dt.multiply(c2)).add(c1)))).add(c0), (CalculusFieldElement)((CalculusFieldElement)dt.multiply(2.0 * c2)).add(c1), (CalculusFieldElement)dt.newInstance(2.0 * c2));
    }

    private AbsoluteDate getSafeReference(AbsoluteDate date) {
        if (this.a0.getReferenceDate() == null) {
            if (this.a1.getValue(date) == 0.0 && this.a2.getValue(date) == 0.0) {
                return date;
            }
            throw new OrekitException((Localizable)OrekitMessages.NO_REFERENCE_DATE_FOR_PARAMETER, this.a0.getName());
        }
        return this.a0.getReferenceDate();
    }

    public QuadraticFieldClockModel<Gradient> toGradientModel(int freeParameters, Map<String, Integer> indices, AbsoluteDate date) {
        Gradient g0 = this.a0.getValue(freeParameters, indices, date);
        Gradient g1 = this.a1.getValue(freeParameters, indices, date);
        Gradient g2 = this.a2.getValue(freeParameters, indices, date);
        FieldAbsoluteDate referenceDate = new FieldAbsoluteDate(g0.getField(), this.getSafeReference(date));
        return new QuadraticFieldClockModel<Gradient>(referenceDate, g0, g1, g2);
    }
}

