/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.utils.ParameterDriver;

public class ObservableSatellite {
    public static final String CLOCK_OFFSET_PREFIX = "clock-offset-satellite-";
    public static final String CLOCK_DRIFT_PREFIX = "clock-drift-satellite-";
    public static final String CLOCK_ACCELERATION_PREFIX = "clock-acceleration-satellite-";
    private static final double CLOCK_OFFSET_SCALE = FastMath.scalb((double)1.0, (int)-10);
    private static final String SAT_PREFIX = "sat-";
    private final int propagatorIndex;
    private final ParameterDriver clockOffsetDriver;
    private final ParameterDriver clockDriftDriver;
    private final ParameterDriver clockAccelerationDriver;

    public ObservableSatellite(int propagatorIndex) {
        this.propagatorIndex = propagatorIndex;
        this.clockOffsetDriver = new ParameterDriver(CLOCK_OFFSET_PREFIX + propagatorIndex, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.clockDriftDriver = new ParameterDriver(CLOCK_DRIFT_PREFIX + propagatorIndex, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.clockAccelerationDriver = new ParameterDriver(CLOCK_ACCELERATION_PREFIX + propagatorIndex, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public String getName() {
        return SAT_PREFIX + this.propagatorIndex;
    }

    public int getPropagatorIndex() {
        return this.propagatorIndex;
    }

    public ParameterDriver getClockOffsetDriver() {
        return this.clockOffsetDriver;
    }

    public ParameterDriver getClockDriftDriver() {
        return this.clockDriftDriver;
    }

    public ParameterDriver getClockAccelerationDriver() {
        return this.clockAccelerationDriver;
    }

    public QuadraticClockModel getQuadraticClockModel() {
        return new QuadraticClockModel(this.clockOffsetDriver, this.clockDriftDriver, this.clockAccelerationDriver);
    }

    public boolean equals(Object other) {
        if (other instanceof ObservableSatellite) {
            return this.propagatorIndex == ((ObservableSatellite)other).propagatorIndex;
        }
        return false;
    }

    public int hashCode() {
        return this.propagatorIndex;
    }
}

