/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class MultiplexedMeasurement
extends AbstractMeasurement<MultiplexedMeasurement> {
    public static final String MEASUREMENT_TYPE = "MultiplexedMeasurement";
    private final List<ObservedMeasurement<?>> observedMeasurements;
    private final List<EstimatedMeasurementBase<?>> estimatedMeasurementsWithoutDerivatives;
    private final List<EstimatedMeasurement<?>> estimatedMeasurements;
    private ParameterDriversList parametersDrivers;
    private final int dimension;
    private final int nbSat;
    private final int[][] mapping;

    /*
     * WARNING - void declaration
     */
    public MultiplexedMeasurement(List<ObservedMeasurement<?>> measurements) {
        super(measurements.get(0).getDate(), MultiplexedMeasurement.multiplex(measurements, m -> m.getObservedValue()), MultiplexedMeasurement.multiplex(measurements, m -> m.getTheoreticalStandardDeviation()), MultiplexedMeasurement.multiplex(measurements, m -> m.getBaseWeight()), MultiplexedMeasurement.multiplex(measurements));
        void var4_8;
        this.observedMeasurements = measurements;
        this.estimatedMeasurementsWithoutDerivatives = new ArrayList();
        this.estimatedMeasurements = new ArrayList();
        this.parametersDrivers = new ParameterDriversList();
        int dim = 0;
        for (ObservedMeasurement<?> observedMeasurement : measurements) {
            for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
                this.parametersDrivers.add(driver);
            }
            dim += observedMeasurement.getDimension();
        }
        this.parametersDrivers.sort();
        for (ParameterDriver parameterDriver : this.parametersDrivers.getDrivers()) {
            this.addParameterDriver(parameterDriver);
        }
        this.dimension = dim;
        List<ObservableSatellite> deduplicated = this.getSatellites();
        this.nbSat = deduplicated.size();
        this.mapping = new int[measurements.size()][];
        boolean bl = false;
        while (var4_8 < this.mapping.length) {
            List<ObservableSatellite> satellites = measurements.get((int)var4_8).getSatellites();
            this.mapping[var4_8] = new int[satellites.size()];
            block4: for (int j = 0; j < this.mapping[var4_8].length; ++j) {
                int index = satellites.get(j).getPropagatorIndex();
                for (int k = 0; k < this.nbSat; ++k) {
                    if (deduplicated.get(k).getPropagatorIndex() != index) continue;
                    this.mapping[var4_8][j] = k;
                    continue block4;
                }
            }
            ++var4_8;
        }
    }

    public List<ObservedMeasurement<?>> getMeasurements() {
        return this.observedMeasurements;
    }

    public List<EstimatedMeasurementBase<?>> getEstimatedMeasurementsWithoutDerivatives() {
        return this.estimatedMeasurementsWithoutDerivatives;
    }

    public List<EstimatedMeasurement<?>> getEstimatedMeasurements() {
        return this.estimatedMeasurements;
    }

    @Override
    protected EstimatedMeasurementBase<MultiplexedMeasurement> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState[] evaluationStates = new SpacecraftState[this.nbSat];
        ArrayList participants = new ArrayList();
        double[] value = new double[this.dimension];
        this.estimatedMeasurementsWithoutDerivatives.clear();
        int index = 0;
        for (int i = 0; i < this.observedMeasurements.size(); ++i) {
            SpacecraftState[] filteredStates = new SpacecraftState[this.mapping[i].length];
            for (int j = 0; j < this.mapping[i].length; ++j) {
                filteredStates[j] = states[this.mapping[i][j]];
            }
            EstimatedMeasurementBase<?> eI = this.observedMeasurements.get(i).estimateWithoutDerivatives(iteration, evaluation, filteredStates);
            this.estimatedMeasurementsWithoutDerivatives.add(eI);
            double[] valueI = eI.getEstimatedValue();
            System.arraycopy(valueI, 0, value, index, valueI.length);
            index += valueI.length;
            SpacecraftState[] statesI = eI.getStates();
            for (int j = 0; j < this.mapping[i].length; ++j) {
                evaluationStates[this.mapping[i][j]] = statesI[j];
            }
        }
        EstimatedMeasurementBase<MultiplexedMeasurement> multiplexed = new EstimatedMeasurementBase<MultiplexedMeasurement>(this, iteration, evaluation, evaluationStates, participants.toArray(new TimeStampedPVCoordinates[0]));
        multiplexed.setEstimatedValue(value);
        return multiplexed;
    }

    @Override
    protected EstimatedMeasurement<MultiplexedMeasurement> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        int i;
        double[][][] stateDerivatives;
        SpacecraftState[] evaluationStates = new SpacecraftState[this.nbSat];
        ArrayList participants = new ArrayList();
        double[] value = new double[this.dimension];
        this.estimatedMeasurements.clear();
        int index = 0;
        for (int i2 = 0; i2 < this.observedMeasurements.size(); ++i2) {
            SpacecraftState[] filteredStates = new SpacecraftState[this.mapping[i2].length];
            for (int j = 0; j < this.mapping[i2].length; ++j) {
                filteredStates[j] = states[this.mapping[i2][j]];
            }
            EstimatedMeasurement<?> eI = this.observedMeasurements.get(i2).estimate(iteration, evaluation, filteredStates);
            this.estimatedMeasurements.add(eI);
            double[] valueI = eI.getEstimatedValue();
            System.arraycopy(valueI, 0, value, index, valueI.length);
            index += valueI.length;
            SpacecraftState[] spacecraftStateArray = eI.getStates();
            for (int j = 0; j < this.mapping[i2].length; ++j) {
                evaluationStates[this.mapping[i2][j]] = spacecraftStateArray[j];
            }
        }
        EstimatedMeasurement<MultiplexedMeasurement> multiplexed = new EstimatedMeasurement<MultiplexedMeasurement>(this, iteration, evaluation, evaluationStates, participants.toArray(new TimeStampedPVCoordinates[0]));
        multiplexed.setEstimatedValue(value);
        int stateSize = this.estimatedMeasurements.get(0).getStateSize();
        double[] zeroDerivative = new double[stateSize];
        for (double[][] m : stateDerivatives = new double[this.nbSat][this.dimension][]) {
            Arrays.fill((Object[])m, zeroDerivative);
        }
        IdentityHashMap identityHashMap = new IdentityHashMap();
        index = 0;
        for (i = 0; i < this.observedMeasurements.size(); ++i) {
            EstimatedMeasurement<?> eI = this.estimatedMeasurements.get(i);
            int idx = index;
            int dimI = eI.getObservedMeasurement().getDimension();
            for (int j = 0; j < this.mapping[i].length; ++j) {
                System.arraycopy(eI.getStateDerivatives(j), 0, stateDerivatives[this.mapping[i][j]], index, dimI);
            }
            eI.getDerivativesDrivers().forEach(driver -> {
                ParameterDriversList.DelegatingDriver delegating = this.parametersDrivers.findByName(driver.getName());
                if (parametersDerivatives.get(delegating) == null) {
                    TimeSpanMap<double[]> derivativeSpanMap = new TimeSpanMap<double[]>(new double[this.dimension]);
                    parametersDerivatives.put(delegating, derivativeSpanMap);
                }
                TimeSpanMap<Double> driverNameSpan = delegating.getValueSpanMap();
                for (TimeSpanMap.Span<Double> span = driverNameSpan.getSpan(driverNameSpan.getFirstSpan().getEnd()); span != null; span = span.next()) {
                    double[] derivatives = (double[])((TimeSpanMap)parametersDerivatives.get(delegating)).get(span.getStart());
                    if (derivatives == null) {
                        derivatives = new double[this.dimension];
                    }
                    if (!((TimeSpanMap)parametersDerivatives.get(delegating)).getSpan(span.getStart()).getStart().equals(span.getStart())) {
                        if (span.getStart().equals(AbsoluteDate.PAST_INFINITY)) {
                            ((TimeSpanMap)parametersDerivatives.get(delegating)).addValidBefore(derivatives, span.getEnd(), false);
                        } else {
                            ((TimeSpanMap)parametersDerivatives.get(delegating)).addValidAfter(derivatives, span.getStart(), false);
                        }
                    }
                    System.arraycopy(eI.getParameterDerivatives((ParameterDriver)driver, span.getStart()), 0, derivatives, idx, dimI);
                }
            });
            index += dimI;
        }
        for (i = 0; i < this.nbSat; ++i) {
            multiplexed.setStateDerivatives(i, stateDerivatives[i]);
        }
        identityHashMap.entrySet().stream().forEach(e -> multiplexed.setParameterDerivatives((ParameterDriver)e.getKey(), (TimeSpanMap)e.getValue()));
        return multiplexed;
    }

    private static double[] multiplex(List<ObservedMeasurement<?>> measurements, Function<ObservedMeasurement<?>, double[]> extractor) {
        ArrayList<double[]> parts = new ArrayList<double[]>(measurements.size());
        int n = 0;
        for (ObservedMeasurement<?> measurement : measurements) {
            double[] p = extractor.apply(measurement);
            parts.add(p);
            n += p.length;
        }
        double[] multiplexed = new double[n];
        int index = 0;
        for (double[] p : parts) {
            System.arraycopy(p, 0, multiplexed, index, p.length);
            index += p.length;
        }
        return multiplexed;
    }

    private static List<ObservableSatellite> multiplex(List<ObservedMeasurement<?>> measurements) {
        ArrayList<ObservableSatellite> satellites = new ArrayList<ObservableSatellite>();
        for (ObservedMeasurement<?> measurement : measurements) {
            for (ObservableSatellite satellite : measurement.getSatellites()) {
                boolean searching = true;
                for (int i = 0; i < satellites.size() && searching; ++i) {
                    searching = satellite.getPropagatorIndex() != ((ObservableSatellite)satellites.get(i)).getPropagatorIndex();
                }
                if (!searching) continue;
                satellites.add(satellite);
            }
        }
        return satellites;
    }
}

