/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesRange
extends AbstractMeasurement<InterSatellitesRange> {
    public static final String MEASUREMENT_TYPE = "InterSatellitesRange";
    private final boolean twoway;

    public InterSatellitesRange(ObservableSatellite local, ObservableSatellite remote, boolean twoWay, AbsoluteDate date, double range, double sigma, double baseWeight) {
        super(date, range, sigma, baseWeight, Arrays.asList(local, remote));
        this.addParameterDriver(local.getClockOffsetDriver());
        this.addParameterDriver(local.getClockDriftDriver());
        this.addParameterDriver(local.getClockAccelerationDriver());
        if (!twoWay) {
            this.addParameterDriver(remote.getClockOffsetDriver());
            this.addParameterDriver(remote.getClockDriftDriver());
            this.addParameterDriver(remote.getClockAccelerationDriver());
        }
        this.twoway = twoWay;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    @Override
    protected EstimatedMeasurementBase<InterSatellitesRange> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        double range;
        EstimatedMeasurementBase<InterSatellitesRange> estimated;
        Frame frame = states[0].getFrame();
        SpacecraftState local = states[0];
        TimeStampedPVCoordinates pvaL = local.getPVCoordinates(frame);
        SpacecraftState remote = states[1];
        TimeStampedPVCoordinates pvaR = remote.getPVCoordinates(frame);
        double dtl = this.getSatellites().get(0).getClockOffsetDriver().getValue(local.getDate());
        AbsoluteDate arrivalDate = this.getDate().shiftedBy(-dtl);
        TimeStampedPVCoordinates s1Downlink = pvaL.shiftedBy(arrivalDate.durationFrom(pvaL.getDate()));
        double tauD = InterSatellitesRange.signalTimeOfFlight(pvaR, s1Downlink.getPosition(), arrivalDate, frame);
        double delta = this.getDate().durationFrom(remote.getDate());
        double deltaMTauD = delta - tauD;
        if (this.twoway) {
            TimeStampedPVCoordinates transitState = pvaR.shiftedBy(deltaMTauD);
            double tauU = InterSatellitesRange.signalTimeOfFlight(pvaL, transitState.getPosition(), transitState.getDate(), frame);
            estimated = new EstimatedMeasurementBase<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD), remote.shiftedBy(deltaMTauD)}, new TimeStampedPVCoordinates[]{local.shiftedBy(delta - tauD - tauU).getPVCoordinates(frame), remote.shiftedBy(delta - tauD).getPVCoordinates(frame), local.shiftedBy(delta).getPVCoordinates(frame)});
            range = (tauD + tauU) * 1.49896229E8;
        } else {
            estimated = new EstimatedMeasurementBase<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD), remote.shiftedBy(deltaMTauD)}, new TimeStampedPVCoordinates[]{remote.shiftedBy(delta - tauD).getPVCoordinates(frame), local.shiftedBy(delta).getPVCoordinates(frame)});
            double dtr = this.getSatellites().get(1).getClockOffsetDriver().getValue(remote.getDate());
            range = (tauD + dtl - dtr) * 2.99792458E8;
        }
        estimated.setEstimatedValue(range);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        Gradient range;
        EstimatedMeasurement<InterSatellitesRange> estimated;
        Frame frame = states[0].getFrame();
        int nbParams = 12;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (indices.containsKey(span.getData())) continue;
                indices.put(span.getData(), nbParams++);
            }
        }
        SpacecraftState local = states[0];
        TimeStampedFieldPVCoordinates<Gradient> pvaL = InterSatellitesRange.getCoordinates(local, 0, nbParams);
        SpacecraftState remote = states[1];
        TimeStampedFieldPVCoordinates<Gradient> pvaR = states[1].getFrame().getTransformTo(frame, states[1].getDate()).transformPVCoordinates(InterSatellitesRange.getCoordinates(remote, 6, nbParams));
        Gradient dtl = this.getSatellites().get(0).getClockOffsetDriver().getValue(nbParams, indices, local.getDate());
        FieldAbsoluteDate<Gradient> arrivalDate = new FieldAbsoluteDate<Gradient>(this.getDate(), dtl.negate());
        FieldPVCoordinates s1Downlink = pvaL.shiftedBy((CalculusFieldElement)arrivalDate.durationFrom(pvaL.getDate()));
        Gradient tauD = InterSatellitesRange.signalTimeOfFlight(pvaR, s1Downlink.getPosition(), arrivalDate, frame);
        double delta = this.getDate().durationFrom(remote.getDate());
        Gradient deltaMTauD = (Gradient)tauD.negate().add(delta);
        if (this.twoway) {
            FieldPVCoordinates transitStateDS = pvaR.shiftedBy((CalculusFieldElement)deltaMTauD);
            Gradient tauU = InterSatellitesRange.signalTimeOfFlight(pvaL, transitStateDS.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateDS).getDate(), frame);
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD.getValue()), remote.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{local.shiftedBy(delta - tauD.getValue() - tauU.getValue()).getPVCoordinates(frame), remote.shiftedBy(delta - tauD.getValue()).getPVCoordinates(frame), local.shiftedBy(delta).getPVCoordinates(frame)});
            range = tauD.add(tauU).multiply(1.49896229E8);
        } else {
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD.getValue()), remote.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{remote.shiftedBy(delta - tauD.getValue()).getPVCoordinates(frame), local.shiftedBy(delta).getPVCoordinates()});
            Gradient dtr = this.getSatellites().get(1).getClockOffsetDriver().getValue(nbParams, indices, remote.getDate());
            range = tauD.add(dtl).subtract(dtr).multiply(2.99792458E8);
        }
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        estimated.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 6, 12)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = (Integer)indices.get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

