/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.BodiesElements;
import org.orekit.data.FundamentalNutationArguments;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedEarthFrameProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.models.earth.displacement.StationDisplacement;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidityProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.UT1Scale;
import org.orekit.utils.ParameterDriver;

public class GroundStation {
    public static final String OFFSET_SUFFIX = "-offset";
    public static final String DRIFT_SUFFIX = "-drift-clock";
    public static final String ACCELERATION_SUFFIX = "-acceleration-clock";
    public static final String INTERMEDIATE_SUFFIX = "-intermediate";
    private static final double CLOCK_OFFSET_SCALE = FastMath.scalb((double)1.0, (int)-10);
    private static final double POSITION_OFFSET_SCALE = FastMath.scalb((double)1.0, (int)0);
    private final EstimatedEarthFrameProvider estimatedEarthFrameProvider;
    private final PressureTemperatureHumidityProvider pthProvider;
    private final Frame estimatedEarthFrame;
    private final TopocentricFrame baseFrame;
    private final FundamentalNutationArguments arguments;
    private final StationDisplacement[] displacements;
    private final ParameterDriver clockOffsetDriver;
    private final ParameterDriver clockDriftDriver;
    private final ParameterDriver clockAccelerationDriver;
    private final ParameterDriver eastOffsetDriver;
    private final ParameterDriver northOffsetDriver;
    private final ParameterDriver zenithOffsetDriver;

    public GroundStation(TopocentricFrame baseFrame) {
        this(baseFrame, TroposphericModelUtils.STANDARD_ATMOSPHERE_PROVIDER, FramesFactory.findEOP(baseFrame), new StationDisplacement[0]);
    }

    public GroundStation(TopocentricFrame baseFrame, PressureTemperatureHumidityProvider pthProvider) {
        this(baseFrame, pthProvider, FramesFactory.findEOP(baseFrame), new StationDisplacement[0]);
    }

    @Deprecated
    public GroundStation(TopocentricFrame baseFrame, EOPHistory eopHistory, StationDisplacement ... displacements) {
        this(baseFrame, TroposphericModelUtils.STANDARD_ATMOSPHERE_PROVIDER, eopHistory, displacements);
    }

    public GroundStation(TopocentricFrame baseFrame, PressureTemperatureHumidityProvider pthProvider, EOPHistory eopHistory, StationDisplacement ... displacements) {
        this.baseFrame = baseFrame;
        this.pthProvider = pthProvider;
        if (eopHistory == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_EARTH_ORIENTATION_PARAMETERS, new Object[0]);
        }
        UT1Scale baseUT1 = eopHistory.getTimeScales().getUT1(eopHistory.getConventions(), eopHistory.isSimpleEop());
        this.estimatedEarthFrameProvider = new EstimatedEarthFrameProvider(baseUT1);
        this.estimatedEarthFrame = new Frame(baseFrame.getParent(), this.estimatedEarthFrameProvider, baseFrame.getParent() + "-estimated");
        this.arguments = displacements.length == 0 ? null : eopHistory.getConventions().getNutationArguments(this.estimatedEarthFrameProvider.getEstimatedUT1(), eopHistory.getTimeScales());
        this.displacements = (StationDisplacement[])displacements.clone();
        this.clockOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-clock", 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.clockDriftDriver = new ParameterDriver(baseFrame.getName() + DRIFT_SUFFIX, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.clockAccelerationDriver = new ParameterDriver(baseFrame.getName() + ACCELERATION_SUFFIX, 0.0, CLOCK_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.eastOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-East", 0.0, POSITION_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.northOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-North", 0.0, POSITION_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.zenithOffsetDriver = new ParameterDriver(baseFrame.getName() + OFFSET_SUFFIX + "-Zenith", 0.0, POSITION_OFFSET_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public PressureTemperatureHumidity getPressureTemperatureHumidity(AbsoluteDate date) {
        return this.pthProvider.getWeatherParamerers(this.getOffsetGeodeticPoint(date), date);
    }

    public <T extends CalculusFieldElement<T>> FieldPressureTemperatureHumidity<T> getPressureTemperatureHumidity(FieldAbsoluteDate<T> date) {
        return this.pthProvider.getWeatherParamerers(this.getOffsetGeodeticPoint(date), date);
    }

    public StationDisplacement[] getDisplacements() {
        return (StationDisplacement[])this.displacements.clone();
    }

    public ParameterDriver getClockOffsetDriver() {
        return this.clockOffsetDriver;
    }

    public ParameterDriver getClockDriftDriver() {
        return this.clockDriftDriver;
    }

    public ParameterDriver getClockAccelerationDriver() {
        return this.clockAccelerationDriver;
    }

    public ParameterDriver getEastOffsetDriver() {
        return this.eastOffsetDriver;
    }

    public ParameterDriver getNorthOffsetDriver() {
        return this.northOffsetDriver;
    }

    public ParameterDriver getZenithOffsetDriver() {
        return this.zenithOffsetDriver;
    }

    public ParameterDriver getPrimeMeridianOffsetDriver() {
        return this.estimatedEarthFrameProvider.getPrimeMeridianOffsetDriver();
    }

    public ParameterDriver getPrimeMeridianDriftDriver() {
        return this.estimatedEarthFrameProvider.getPrimeMeridianDriftDriver();
    }

    public ParameterDriver getPolarOffsetXDriver() {
        return this.estimatedEarthFrameProvider.getPolarOffsetXDriver();
    }

    public ParameterDriver getPolarDriftXDriver() {
        return this.estimatedEarthFrameProvider.getPolarDriftXDriver();
    }

    public ParameterDriver getPolarOffsetYDriver() {
        return this.estimatedEarthFrameProvider.getPolarOffsetYDriver();
    }

    public ParameterDriver getPolarDriftYDriver() {
        return this.estimatedEarthFrameProvider.getPolarDriftYDriver();
    }

    public TopocentricFrame getBaseFrame() {
        return this.baseFrame;
    }

    public Frame getEstimatedEarthFrame() {
        return this.estimatedEarthFrame;
    }

    public UT1Scale getEstimatedUT1() {
        return this.estimatedEarthFrameProvider.getEstimatedUT1();
    }

    private Vector3D computeDisplacement(AbsoluteDate date, Vector3D position) {
        Vector3D displacement = Vector3D.ZERO;
        if (this.arguments != null) {
            BodiesElements elements = this.arguments.evaluateAll(date);
            for (StationDisplacement sd : this.displacements) {
                displacement = displacement.add((Vector)sd.displacement(elements, this.estimatedEarthFrame, position));
            }
        }
        return displacement;
    }

    public GeodeticPoint getOffsetGeodeticPoint(AbsoluteDate date) {
        double x = this.eastOffsetDriver.getValue();
        double y = this.northOffsetDriver.getValue();
        double z = this.zenithOffsetDriver.getValue();
        BodyShape baseShape = this.baseFrame.getParentShape();
        StaticTransform baseToBody = this.baseFrame.getStaticTransformTo(baseShape.getBodyFrame(), date);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        if (date != null) {
            origin = origin.add((Vector)this.computeDisplacement(date, origin));
        }
        return baseShape.transform(origin, baseShape.getBodyFrame(), date);
    }

    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> getOffsetGeodeticPoint(FieldAbsoluteDate<T> date) {
        double x = this.eastOffsetDriver.getValue();
        double y = this.northOffsetDriver.getValue();
        double z = this.zenithOffsetDriver.getValue();
        BodyShape baseShape = this.baseFrame.getParentShape();
        FieldStaticTransform<T> baseToBody = this.baseFrame.getStaticTransformTo(baseShape.getBodyFrame(), date);
        FieldVector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        origin = origin.add(this.computeDisplacement(date.toAbsoluteDate(), origin.toVector3D()));
        return baseShape.transform(origin, baseShape.getBodyFrame(), date);
    }

    public Transform getOffsetToInertial(Frame inertial, AbsoluteDate date, boolean clockOffsetAlreadyApplied) {
        AbsoluteDate offsetCompensatedDate = clockOffsetAlreadyApplied ? date : new AbsoluteDate(date, -this.clockOffsetDriver.getValue());
        Transform intermediateToBody = this.estimatedEarthFrameProvider.getTransform(offsetCompensatedDate).getInverse();
        double x = this.eastOffsetDriver.getValue();
        double y = this.northOffsetDriver.getValue();
        double z = this.zenithOffsetDriver.getValue();
        BodyShape baseShape = this.baseFrame.getParentShape();
        StaticTransform baseToBody = this.baseFrame.getStaticTransformTo(baseShape.getBodyFrame(), offsetCompensatedDate);
        Vector3D origin = baseToBody.transformPosition(new Vector3D(x, y, z));
        origin = origin.add((Vector)this.computeDisplacement(offsetCompensatedDate, origin));
        GeodeticPoint originGP = baseShape.transform(origin, baseShape.getBodyFrame(), offsetCompensatedDate);
        Transform offsetToIntermediate = new Transform(offsetCompensatedDate, new Transform(offsetCompensatedDate, new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_K, originGP.getEast(), originGP.getZenith()), Vector3D.ZERO), new Transform(offsetCompensatedDate, origin));
        Transform bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, offsetCompensatedDate);
        return new Transform(offsetCompensatedDate, offsetToIntermediate, new Transform(offsetCompensatedDate, intermediateToBody, bodyToInert));
    }

    public FieldTransform<Gradient> getOffsetToInertial(Frame inertial, AbsoluteDate clockDate, int freeParameters, Map<String, Integer> indices) {
        Gradient offset = this.clockOffsetDriver.getValue(freeParameters, indices, clockDate);
        FieldAbsoluteDate<Gradient> offsetCompensatedDate = new FieldAbsoluteDate<Gradient>(clockDate, offset.negate());
        return this.getOffsetToInertial(inertial, offsetCompensatedDate, freeParameters, indices);
    }

    public FieldTransform<Gradient> getOffsetToInertial(Frame inertial, FieldAbsoluteDate<Gradient> offsetCompensatedDate, int freeParameters, Map<String, Integer> indices) {
        Field<Gradient> field = offsetCompensatedDate.getField();
        FieldVector3D zero = FieldVector3D.getZero(field);
        FieldVector3D plusI = FieldVector3D.getPlusI(field);
        FieldVector3D plusK = FieldVector3D.getPlusK(field);
        FieldKinematicTransform intermediateToBody = this.estimatedEarthFrameProvider.getTransform(offsetCompensatedDate, freeParameters, indices).getInverse();
        Gradient x = this.eastOffsetDriver.getValue(freeParameters, indices);
        Gradient y = this.northOffsetDriver.getValue(freeParameters, indices);
        Gradient z = this.zenithOffsetDriver.getValue(freeParameters, indices);
        BodyShape baseShape = this.baseFrame.getParentShape();
        FieldStaticTransform<Gradient> baseToBody = this.baseFrame.getStaticTransformTo(baseShape.getBodyFrame(), offsetCompensatedDate);
        FieldVector3D origin = baseToBody.transformPosition((FieldVector3D<Gradient>)new FieldVector3D((CalculusFieldElement)x, (CalculusFieldElement)y, (CalculusFieldElement)z));
        origin = origin.add(this.computeDisplacement(offsetCompensatedDate.toAbsoluteDate(), origin.toVector3D()));
        FieldGeodeticPoint<Gradient> originGP = baseShape.transform(origin, baseShape.getBodyFrame(), offsetCompensatedDate);
        FieldTransform<Gradient> offsetToIntermediate = new FieldTransform<Gradient>(offsetCompensatedDate, new FieldTransform<Gradient>(offsetCompensatedDate, new FieldRotation(plusI, plusK, originGP.getEast(), originGP.getZenith()), zero), new FieldTransform<Gradient>(offsetCompensatedDate, origin));
        FieldTransform<Gradient> bodyToInert = this.baseFrame.getParent().getTransformTo(inertial, offsetCompensatedDate);
        return new FieldTransform<Gradient>(offsetCompensatedDate, offsetToIntermediate, new FieldTransform<Gradient>(offsetCompensatedDate, (FieldTransform<Gradient>)intermediateToBody, bodyToInert));
    }
}

