/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class GroundReceiverMeasurement<T extends GroundReceiverMeasurement<T>>
extends AbstractMeasurement<T> {
    private final GroundStation station;
    private final boolean twoway;

    public GroundReceiverMeasurement(GroundStation station, boolean twoWay, AbsoluteDate date, double observed, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, observed, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getClockDriftDriver());
        this.addParameterDriver(station.getClockAccelerationDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        if (!twoWay) {
            this.addParameterDriver(satellite.getClockOffsetDriver());
            this.addParameterDriver(satellite.getClockDriftDriver());
            this.addParameterDriver(satellite.getClockAccelerationDriver());
        }
        this.station = station;
        this.twoway = twoWay;
    }

    public GroundReceiverMeasurement(GroundStation station, boolean twoWay, AbsoluteDate date, double[] observed, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(date, observed, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(station.getClockOffsetDriver());
        this.addParameterDriver(station.getClockDriftDriver());
        this.addParameterDriver(station.getClockAccelerationDriver());
        this.addParameterDriver(station.getEastOffsetDriver());
        this.addParameterDriver(station.getNorthOffsetDriver());
        this.addParameterDriver(station.getZenithOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(station.getPrimeMeridianDriftDriver());
        this.addParameterDriver(station.getPolarOffsetXDriver());
        this.addParameterDriver(station.getPolarDriftXDriver());
        this.addParameterDriver(station.getPolarOffsetYDriver());
        this.addParameterDriver(station.getPolarDriftYDriver());
        if (!twoWay) {
            this.addParameterDriver(satellite.getClockOffsetDriver());
            this.addParameterDriver(satellite.getClockDriftDriver());
            this.addParameterDriver(satellite.getClockAccelerationDriver());
        }
        this.station = station;
        this.twoway = twoWay;
    }

    public GroundStation getStation() {
        return this.station;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    protected GroundReceiverCommonParametersWithoutDerivatives computeCommonParametersWithout(SpacecraftState state) {
        TimeStampedPVCoordinates pva = state.getPVCoordinates();
        Transform offsetToInertialDownlink = this.getStation().getOffsetToInertial(state.getFrame(), this.getDate(), false);
        AbsoluteDate downlinkDate = offsetToInertialDownlink.getDate();
        TimeStampedPVCoordinates origin = new TimeStampedPVCoordinates(downlinkDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO);
        TimeStampedPVCoordinates stationDownlink = offsetToInertialDownlink.transformPVCoordinates(origin);
        double tauD = GroundReceiverMeasurement.signalTimeOfFlight(pva, stationDownlink.getPosition(), downlinkDate, state.getFrame());
        double delta = downlinkDate.durationFrom(state.getDate());
        double deltaMTauD = delta - tauD;
        SpacecraftState transitState = state.shiftedBy(deltaMTauD);
        return new GroundReceiverCommonParametersWithoutDerivatives(state, offsetToInertialDownlink, stationDownlink, tauD, transitState, transitState.getPVCoordinates());
    }

    protected GroundReceiverCommonParametersWithDerivatives computeCommonParametersWithDerivatives(SpacecraftState state) {
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                indices.put(span.getData(), nbParams++);
            }
        }
        FieldVector3D zero = FieldVector3D.getZero((Field)GradientField.getField((int)nbParams));
        TimeStampedFieldPVCoordinates<Gradient> pva = GroundReceiverMeasurement.getCoordinates(state, 0, nbParams);
        FieldTransform<Gradient> offsetToInertialDownlink = this.getStation().getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> downlinkDate = offsetToInertialDownlink.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(downlinkDate, zero, zero, zero));
        Gradient tauD = GroundReceiverMeasurement.signalTimeOfFlight(pva, stationDownlink.getPosition(), downlinkDate, state.getFrame());
        Gradient delta = downlinkDate.durationFrom(state.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitPV = pva.shiftedBy((CalculusFieldElement)deltaMTauD);
        return new GroundReceiverCommonParametersWithDerivatives(state, indices, offsetToInertialDownlink, stationDownlink, tauD, transitState, (TimeStampedFieldPVCoordinates<Gradient>)transitPV);
    }

    public Vector3D getGroundStationPosition(Frame frame) {
        return this.station.getBaseFrame().getPosition(this.getDate(), frame);
    }

    public PVCoordinates getGroundStationCoordinates(Frame frame) {
        return this.station.getBaseFrame().getPVCoordinates(this.getDate(), frame);
    }
}

