/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.TDOA;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FDOA
extends GroundReceiverMeasurement<FDOA> {
    public static final String MEASUREMENT_TYPE = "FDOA";
    private final double centreFrequency;
    private final GroundStation secondStation;

    public FDOA(GroundStation primeStation, GroundStation secondStation, double centreFrequency, AbsoluteDate date, double fdoa, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(primeStation, false, date, fdoa, sigma, baseWeight, satellite);
        this.addParameterDriver(secondStation.getClockOffsetDriver());
        this.addParameterDriver(secondStation.getEastOffsetDriver());
        this.addParameterDriver(secondStation.getNorthOffsetDriver());
        this.addParameterDriver(secondStation.getZenithOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(secondStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(secondStation.getPolarOffsetXDriver());
        this.addParameterDriver(secondStation.getPolarDriftXDriver());
        this.addParameterDriver(secondStation.getPolarOffsetYDriver());
        this.addParameterDriver(secondStation.getPolarDriftYDriver());
        this.secondStation = secondStation;
        this.centreFrequency = centreFrequency;
    }

    public GroundStation getPrimeStation() {
        return this.getStation();
    }

    public GroundStation getSecondStation() {
        return this.secondStation;
    }

    @Override
    protected EstimatedMeasurementBase<FDOA> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates emitterPV = common.getTransitPV();
        AbsoluteDate emitterDate = emitterPV.getDate();
        Transform secondToInertial = this.getSecondStation().getOffsetToInertial(common.getState().getFrame(), emitterDate, true);
        TimeStampedPVCoordinates secondApprox = secondToInertial.transformPVCoordinates(new TimeStampedPVCoordinates(emitterDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double tau2 = TDOA.forwardSignalTimeOfFlight(secondApprox, emitterPV.getPosition(), emitterDate);
        TimeStampedPVCoordinates secondPV = secondApprox.shiftedBy(tau2);
        double offset1 = this.getPrimeStation().getClockOffsetDriver().getValue(emitterDate);
        double offset2 = this.getSecondStation().getClockOffsetDriver().getValue(emitterDate);
        double tdoa = common.getTauD() + offset1 - (tau2 + offset2);
        EstimatedMeasurement<FDOA> estimated = new EstimatedMeasurement<FDOA>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{emitterPV, tdoa > 0.0 ? secondPV : common.getStationDownlink(), tdoa > 0.0 ? common.getStationDownlink() : secondPV});
        Vector3D primeDirection = (Vector3D)common.getStationDownlink().getPosition().subtract((Vector)emitterPV.getPosition()).normalize();
        Vector3D secondDirection = (Vector3D)secondPV.getPosition().subtract((Vector)emitterPV.getPosition()).normalize();
        Vector3D primeVelocity = common.getStationDownlink().getVelocity().subtract((Vector)emitterPV.getVelocity());
        Vector3D secondVelocity = secondPV.getVelocity().subtract((Vector)emitterPV.getVelocity());
        double rangeRateDifference = Vector3D.dotProduct((Vector3D)primeDirection, (Vector3D)primeVelocity) - Vector3D.dotProduct((Vector3D)secondDirection, (Vector3D)secondVelocity);
        double rangeRateToHz = -this.centreFrequency / 2.99792458E8;
        estimated.setEstimatedValue(rangeRateDifference * rangeRateToHz);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<FDOA> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> emitterPV = common.getTransitPV();
        FieldAbsoluteDate<Gradient> emitterDate = emitterPV.getDate();
        FieldVector3D zero = FieldVector3D.getZero((Field)common.getTauD().getField());
        FieldTransform<Gradient> secondToInertial = this.getSecondStation().getOffsetToInertial(state.getFrame(), emitterDate, nbParams, common.getIndices());
        TimeStampedFieldPVCoordinates<Gradient> secondApprox = secondToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(emitterDate, zero, zero, zero));
        Gradient tau2 = TDOA.forwardSignalTimeOfFlight(secondApprox, emitterPV.getPosition(), emitterDate);
        FieldPVCoordinates secondPV = secondApprox.shiftedBy((CalculusFieldElement)tau2);
        Gradient offset1 = this.getPrimeStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), emitterDate.toAbsoluteDate());
        Gradient offset2 = this.getSecondStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), emitterDate.toAbsoluteDate());
        Gradient tdoaG = common.getTauD().add(offset1).subtract(tau2.add(offset2));
        double tdoa = tdoaG.getValue();
        TimeStampedPVCoordinates pv1 = common.getStationDownlink().toTimeStampedPVCoordinates();
        TimeStampedPVCoordinates pv2 = ((TimeStampedFieldPVCoordinates)secondPV).toTimeStampedPVCoordinates();
        EstimatedMeasurement<FDOA> estimated = new EstimatedMeasurement<FDOA>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{emitterPV.toTimeStampedPVCoordinates(), tdoa > 0.0 ? pv2 : pv1, tdoa > 0.0 ? pv1 : pv2});
        FieldVector3D primeDirection = common.getStationDownlink().getPosition().subtract(emitterPV.getPosition()).normalize();
        FieldVector3D secondDirection = secondPV.getPosition().subtract(emitterPV.getPosition()).normalize();
        FieldVector3D primeVelocity = common.getStationDownlink().getVelocity().subtract(emitterPV.getVelocity());
        FieldVector3D secondVelocity = secondPV.getVelocity().subtract(emitterPV.getVelocity());
        Gradient rangeRateDifference = ((Gradient)FieldVector3D.dotProduct((FieldVector3D)primeDirection, (FieldVector3D)primeVelocity)).subtract((Gradient)FieldVector3D.dotProduct((FieldVector3D)secondDirection, (FieldVector3D)secondVelocity));
        double rangeRateToHz = -this.centreFrequency / 2.99792458E8;
        Gradient fdoa = rangeRateDifference.multiply(rangeRateToHz);
        estimated.setEstimatedValue(fdoa.getValue());
        double[] derivatives = fdoa.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

