/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.IdentityHashMap;
import org.orekit.estimation.measurements.ComparableMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EstimatedMeasurementBase<T extends ObservedMeasurement<T>>
implements ComparableMeasurement {
    private final T observedMeasurement;
    private final int iteration;
    private final int count;
    private final SpacecraftState[] states;
    private final TimeStampedPVCoordinates[] participants;
    private double[] originalEstimatedValue;
    private double[] estimatedValue;
    private final IdentityHashMap<EstimationModifier<T>, double[]> appliedEffects;
    private Status status;

    public EstimatedMeasurementBase(T observedMeasurement, int iteration, int count, SpacecraftState[] states, TimeStampedPVCoordinates[] participants) {
        this.observedMeasurement = observedMeasurement;
        this.iteration = iteration;
        this.count = count;
        this.states = (SpacecraftState[])states.clone();
        this.participants = (TimeStampedPVCoordinates[])participants.clone();
        this.status = Status.PROCESSED;
        this.appliedEffects = new IdentityHashMap();
    }

    public T getObservedMeasurement() {
        return this.observedMeasurement;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.observedMeasurement.getDate();
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getCount() {
        return this.count;
    }

    public SpacecraftState[] getStates() {
        return (SpacecraftState[])this.states.clone();
    }

    public TimeStampedPVCoordinates[] getParticipants() {
        return (TimeStampedPVCoordinates[])this.participants.clone();
    }

    public double getTimeOffset() {
        return this.observedMeasurement.getDate().durationFrom(this.states[0].getDate());
    }

    @Override
    public double[] getObservedValue() {
        return this.observedMeasurement.getObservedValue();
    }

    public double[] getOriginalEstimatedValue() {
        return (double[])this.originalEstimatedValue.clone();
    }

    public IdentityHashMap<EstimationModifier<T>, double[]> getAppliedEffects() {
        return this.appliedEffects;
    }

    public double[] getEstimatedValue() {
        return (double[])this.estimatedValue.clone();
    }

    public void setEstimatedValue(double ... estimatedValue) {
        if (this.originalEstimatedValue == null) {
            this.originalEstimatedValue = (double[])estimatedValue.clone();
        }
        this.estimatedValue = (double[])estimatedValue.clone();
    }

    public void modifyEstimatedValue(EstimationModifier<T> modifier, double ... newEstimatedValue) {
        if (modifier == null) {
            this.setEstimatedValue(newEstimatedValue);
        } else {
            double[] effect = new double[newEstimatedValue.length];
            for (int i = 0; i < effect.length; ++i) {
                effect[i] = newEstimatedValue[i] - this.estimatedValue[i];
                this.estimatedValue[i] = newEstimatedValue[i];
            }
            this.appliedEffects.put(modifier, effect);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum Status {
        PROCESSED,
        REJECTED;

    }
}

