/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EstimatedMeasurement<T extends ObservedMeasurement<T>>
extends EstimatedMeasurementBase<T> {
    private double[][][] stateDerivatives;
    private final Map<ParameterDriver, TimeSpanMap<double[]>> parametersDerivatives;

    public EstimatedMeasurement(T observedMeasurement, int iteration, int count, SpacecraftState[] states, TimeStampedPVCoordinates[] participants) {
        super(observedMeasurement, iteration, count, states, participants);
        this.stateDerivatives = new double[states.length][][];
        this.parametersDerivatives = new IdentityHashMap<ParameterDriver, TimeSpanMap<double[]>>();
    }

    public EstimatedMeasurement(EstimatedMeasurementBase<T> estimatedMeasurementBase) {
        this(estimatedMeasurementBase.getObservedMeasurement(), estimatedMeasurementBase.getIteration(), estimatedMeasurementBase.getCount(), estimatedMeasurementBase.getStates(), estimatedMeasurementBase.getParticipants());
        this.setEstimatedValue(estimatedMeasurementBase.getEstimatedValue());
        this.setStatus(estimatedMeasurementBase.getStatus());
    }

    public int getStateSize() {
        return this.stateDerivatives[0][0].length;
    }

    public double[][] getStateDerivatives(int index) {
        double[][] sd = new double[this.getObservedMeasurement().getDimension()][];
        for (int i = 0; i < this.getObservedMeasurement().getDimension(); ++i) {
            sd[i] = (double[])this.stateDerivatives[index][i].clone();
        }
        return sd;
    }

    public void setStateDerivatives(int index, double[] ... derivatives) {
        this.stateDerivatives[index] = new double[this.getObservedMeasurement().getDimension()][];
        for (int i = 0; i < this.getObservedMeasurement().getDimension(); ++i) {
            this.stateDerivatives[index][i] = (double[])derivatives[i].clone();
        }
    }

    public Stream<ParameterDriver> getDerivativesDrivers() {
        return this.parametersDerivatives.entrySet().stream().map(entry -> (ParameterDriver)entry.getKey());
    }

    public double[] getParameterDerivatives(ParameterDriver driver) throws OrekitIllegalArgumentException {
        if (driver.getNbOfValues() == 1) {
            TimeSpanMap<double[]> p = this.parametersDerivatives.get(driver);
            if (p == null) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<ParameterDriver, TimeSpanMap<double[]>> entry : this.parametersDerivatives.entrySet()) {
                    if (builder.length() > 0) {
                        builder.append(",  ");
                    }
                    builder.append(entry.getKey());
                }
                throw new OrekitIllegalArgumentException(OrekitMessages.UNSUPPORTED_PARAMETER_NAME, driver, builder.length() > 0 ? builder.toString() : " <none>");
            }
            return p.get(AbsoluteDate.ARBITRARY_EPOCH);
        }
        throw new OrekitIllegalStateException(OrekitMessages.PARAMETER_WITH_SEVERAL_ESTIMATED_VALUES, driver.getName(), "getParameterDerivatives(driver, date)");
    }

    public double[] getParameterDerivatives(ParameterDriver driver, AbsoluteDate date) throws OrekitIllegalArgumentException {
        TimeSpanMap<double[]> p = this.parametersDerivatives.get(driver);
        if (p == null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<ParameterDriver, TimeSpanMap<double[]>> entry : this.parametersDerivatives.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(entry.getKey());
            }
            throw new OrekitIllegalArgumentException(OrekitMessages.UNSUPPORTED_PARAMETER_NAME, driver, builder.length() > 0 ? builder.toString() : "<none>");
        }
        return p.get(date);
    }

    public void setParameterDerivatives(ParameterDriver driver, AbsoluteDate date, double ... parameterDerivatives) {
        if (!this.parametersDerivatives.containsKey(driver) || this.parametersDerivatives.get(driver) == null) {
            TimeSpanMap<double[]> derivativeSpanMap = new TimeSpanMap<double[]>(parameterDerivatives);
            TimeSpanMap<String> driverNameSpan = driver.getNamesSpanMap();
            for (TimeSpanMap.Span<String> span = driverNameSpan.getSpan(driverNameSpan.getFirstSpan().getEnd()); span != null; span = span.next()) {
                derivativeSpanMap.addValidAfter(parameterDerivatives, span.getStart(), false);
            }
            this.parametersDerivatives.put(driver, derivativeSpanMap);
        } else {
            AbsoluteDate dateToAddAfter = driver.getNamesSpanMap().getSpan(date).getStart();
            if (dateToAddAfter.equals(AbsoluteDate.PAST_INFINITY)) {
                dateToAddAfter = driver.getNamesSpanMap().getSpan(date).getEnd();
                this.parametersDerivatives.get(driver).addValidBefore(parameterDerivatives, dateToAddAfter, false);
            } else {
                this.parametersDerivatives.get(driver).addValidAfter(parameterDerivatives, dateToAddAfter, false);
            }
        }
    }

    public void setParameterDerivatives(ParameterDriver driver, TimeSpanMap<double[]> parameterDerivativesMap) {
        this.parametersDerivatives.put(driver, parameterDerivativesMap);
    }
}

