/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BistaticRangeRate
extends GroundReceiverMeasurement<BistaticRangeRate> {
    public static final String MEASUREMENT_TYPE = "BistaticRangeRate";
    private final GroundStation emitter;

    public BistaticRangeRate(GroundStation emitter, GroundStation receiver, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(receiver, true, date, rangeRate, sigma, baseWeight, satellite);
        this.addParameterDriver(emitter.getEastOffsetDriver());
        this.addParameterDriver(emitter.getNorthOffsetDriver());
        this.addParameterDriver(emitter.getZenithOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianDriftDriver());
        this.addParameterDriver(emitter.getPolarOffsetXDriver());
        this.addParameterDriver(emitter.getPolarDriftXDriver());
        this.addParameterDriver(emitter.getPolarOffsetYDriver());
        this.addParameterDriver(emitter.getPolarDriftYDriver());
        this.emitter = emitter;
    }

    public GroundStation getEmitterStation() {
        return this.emitter;
    }

    public GroundStation getReceiverStation() {
        return this.getStation();
    }

    @Override
    protected EstimatedMeasurementBase<BistaticRangeRate> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitPV();
        AbsoluteDate transitDate = transitPV.getDate();
        Transform emitterToInertial = this.getEmitterStation().getOffsetToInertial(common.getState().getFrame(), transitDate, true);
        TimeStampedPVCoordinates emitterApprox = emitterToInertial.transformPVCoordinates(new TimeStampedPVCoordinates(transitDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double tauU = BistaticRangeRate.signalTimeOfFlight(emitterApprox, transitPV.getPosition(), transitDate, common.getState().getFrame());
        TimeStampedPVCoordinates emitterPV = emitterApprox.shiftedBy(-tauU);
        EstimatedMeasurementBase<BistaticRangeRate> estimated = new EstimatedMeasurementBase<BistaticRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getStationDownlink(), transitPV, emitterPV});
        Vector3D receiverDirection = (Vector3D)common.getStationDownlink().getPosition().subtract((Vector)transitPV.getPosition()).normalize();
        Vector3D emitterDirection = (Vector3D)emitterPV.getPosition().subtract((Vector)transitPV.getPosition()).normalize();
        Vector3D receiverVelocity = common.getStationDownlink().getVelocity().subtract((Vector)transitPV.getVelocity());
        Vector3D emitterVelocity = emitterPV.getVelocity().subtract((Vector)transitPV.getVelocity());
        double rangeRate = Vector3D.dotProduct((Vector3D)receiverDirection, (Vector3D)receiverVelocity) + Vector3D.dotProduct((Vector3D)emitterDirection, (Vector3D)emitterVelocity);
        estimated.setEstimatedValue(rangeRate);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<BistaticRangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        FieldAbsoluteDate<Gradient> transitDate = transitPV.getDate();
        FieldVector3D zero = FieldVector3D.getZero((Field)common.getTauD().getField());
        FieldTransform<Gradient> emitterToInertial = this.getEmitterStation().getOffsetToInertial(state.getFrame(), transitDate, nbParams, common.getIndices());
        TimeStampedFieldPVCoordinates<Gradient> emitterApprox = emitterToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(transitDate, zero, zero, zero));
        Gradient tauU = BistaticRangeRate.signalTimeOfFlight(emitterApprox, transitPV.getPosition(), transitPV.getDate(), state.getFrame());
        FieldPVCoordinates emitterPV = emitterApprox.shiftedBy((CalculusFieldElement)tauU.negate());
        EstimatedMeasurement<BistaticRangeRate> estimated = new EstimatedMeasurement<BistaticRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getStationDownlink().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates(), ((TimeStampedFieldPVCoordinates)emitterPV).toTimeStampedPVCoordinates()});
        FieldVector3D receiverDirection = common.getStationDownlink().getPosition().subtract(transitPV.getPosition()).normalize();
        FieldVector3D emitterDirection = emitterPV.getPosition().subtract(transitPV.getPosition()).normalize();
        FieldVector3D receiverVelocity = common.getStationDownlink().getVelocity().subtract(transitPV.getVelocity());
        FieldVector3D emitterVelocity = emitterPV.getVelocity().subtract(transitPV.getVelocity());
        Gradient rangeRate = ((Gradient)FieldVector3D.dotProduct((FieldVector3D)receiverDirection, (FieldVector3D)receiverVelocity)).add((Gradient)FieldVector3D.dotProduct((FieldVector3D)emitterDirection, (FieldVector3D)emitterVelocity));
        estimated.setEstimatedValue(rangeRate.getValue());
        double[] derivatives = rangeRate.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

