/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BistaticRange
extends GroundReceiverMeasurement<BistaticRange> {
    public static final String MEASUREMENT_TYPE = "BistaticRange";
    private final GroundStation emitter;

    public BistaticRange(GroundStation emitter, GroundStation receiver, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(receiver, true, date, range, sigma, baseWeight, satellite);
        this.addParameterDriver(emitter.getClockOffsetDriver());
        this.addParameterDriver(emitter.getEastOffsetDriver());
        this.addParameterDriver(emitter.getNorthOffsetDriver());
        this.addParameterDriver(emitter.getZenithOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(emitter.getPrimeMeridianDriftDriver());
        this.addParameterDriver(emitter.getPolarOffsetXDriver());
        this.addParameterDriver(emitter.getPolarDriftXDriver());
        this.addParameterDriver(emitter.getPolarOffsetYDriver());
        this.addParameterDriver(emitter.getPolarDriftYDriver());
        this.emitter = emitter;
    }

    public GroundStation getEmitterStation() {
        return this.emitter;
    }

    public GroundStation getReceiverStation() {
        return this.getStation();
    }

    @Override
    protected EstimatedMeasurementBase<BistaticRange> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitPV();
        AbsoluteDate transitDate = transitPV.getDate();
        Transform emitterToInertial = this.getEmitterStation().getOffsetToInertial(common.getState().getFrame(), transitDate, true);
        TimeStampedPVCoordinates emitterApprox = emitterToInertial.transformPVCoordinates(new TimeStampedPVCoordinates(transitDate, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
        double tauU = BistaticRange.signalTimeOfFlight(emitterApprox, transitPV.getPosition(), transitDate, common.getState().getFrame());
        TimeStampedPVCoordinates emitterPV = emitterApprox.shiftedBy(-tauU);
        EstimatedMeasurementBase<BistaticRange> estimated = new EstimatedMeasurementBase<BistaticRange>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getStationDownlink(), transitPV, emitterPV});
        double dte = this.getEmitterStation().getClockOffsetDriver().getValue(common.getState().getDate());
        double dtr = this.getReceiverStation().getClockOffsetDriver().getValue(common.getState().getDate());
        double tau = common.getTauD() + tauU + dtr - dte;
        double range = tau * 2.99792458E8;
        estimated.setEstimatedValue(range);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<BistaticRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        FieldAbsoluteDate<Gradient> transitDate = transitPV.getDate();
        FieldVector3D zero = FieldVector3D.getZero((Field)common.getTauD().getField());
        FieldTransform<Gradient> emitterToInertial = this.getEmitterStation().getOffsetToInertial(state.getFrame(), transitDate, nbParams, common.getIndices());
        TimeStampedFieldPVCoordinates<Gradient> emitterApprox = emitterToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(transitDate, zero, zero, zero));
        Gradient tauU = BistaticRange.signalTimeOfFlight(emitterApprox, transitPV.getPosition(), transitPV.getDate(), state.getFrame());
        FieldPVCoordinates emitterPV = emitterApprox.shiftedBy((CalculusFieldElement)tauU.negate());
        EstimatedMeasurement<BistaticRange> estimated = new EstimatedMeasurement<BistaticRange>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getStationDownlink().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates(), ((TimeStampedFieldPVCoordinates)emitterPV).toTimeStampedPVCoordinates()});
        Gradient dte = this.getEmitterStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), state.getDate());
        Gradient dtr = this.getReceiverStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), state.getDate());
        Gradient tau = common.getTauD().add(tauU).add(dtr).subtract(dte);
        Gradient range = tau.multiply(2.99792458E8);
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

