/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularRaDec
extends GroundReceiverMeasurement<AngularRaDec> {
    public static final String MEASUREMENT_TYPE = "AngularRaDec";
    private final Frame referenceFrame;

    public AngularRaDec(GroundStation station, Frame referenceFrame, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(station, false, date, angular, sigma, baseWeight, satellite);
        this.referenceFrame = referenceFrame;
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    protected EstimatedMeasurementBase<AngularRaDec> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitPV();
        Vector3D staSatInertial = transitPV.getPosition().subtract((Vector)common.getStationDownlink().getPosition());
        StaticTransform inertialToReferenceDownlink = common.getState().getFrame().getStaticTransformTo(this.referenceFrame, common.getStationDownlink().getDate());
        Vector3D staSatReference = inertialToReferenceDownlink.transformVector(staSatInertial);
        double baseRightAscension = staSatReference.getAlpha();
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension, (double)this.getObservedValue()[0]) - baseRightAscension;
        double rightAscension = baseRightAscension + twoPiWrap;
        double declination = staSatReference.getDelta();
        EstimatedMeasurementBase<AngularRaDec> estimated = new EstimatedMeasurementBase<AngularRaDec>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV, common.getStationDownlink()});
        estimated.setEstimatedValue(rightAscension, declination);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<AngularRaDec> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        FieldVector3D staSatInertial = transitPV.getPosition().subtract(common.getStationDownlink().getPosition());
        FieldStaticTransform<Gradient> inertialToReferenceDownlink = state.getFrame().getStaticTransformTo(this.referenceFrame, common.getStationDownlink().getDate());
        FieldVector3D<Gradient> staSatReference = inertialToReferenceDownlink.transformVector((FieldVector3D<Gradient>)staSatInertial);
        Gradient baseRightAscension = (Gradient)staSatReference.getAlpha();
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension.getReal(), (double)this.getObservedValue()[0]) - baseRightAscension.getReal();
        Gradient rightAscension = (Gradient)baseRightAscension.add(twoPiWrap);
        Gradient declination = (Gradient)staSatReference.getDelta();
        EstimatedMeasurement<AngularRaDec> estimated = new EstimatedMeasurement<AngularRaDec>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV.toTimeStampedPVCoordinates(), common.getStationDownlink().toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(rightAscension.getValue(), declination.getValue());
        double[] raDerivatives = rightAscension.getGradient();
        double[] decDerivatives = declination.getGradient();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(raDerivatives, 0, 6), Arrays.copyOfRange(decDerivatives, 0, 6));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), raDerivatives[index], decDerivatives[index]);
            }
        }
        return estimated;
    }

    public Vector3D getObservedLineOfSight(Frame outputFrame) {
        return this.referenceFrame.getStaticTransformTo(outputFrame, this.getDate()).transformVector(new Vector3D(this.getObservedValue()[0], this.getObservedValue()[1]));
    }
}

