/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularAzEl
extends GroundReceiverMeasurement<AngularAzEl> {
    public static final String MEASUREMENT_TYPE = "AngularAzEl";

    public AngularAzEl(GroundStation station, AbsoluteDate date, double[] angular, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(station, false, date, angular, sigma, baseWeight, satellite);
    }

    @Override
    protected EstimatedMeasurementBase<AngularAzEl> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        TimeStampedPVCoordinates transitPV = common.getTransitPV();
        Vector3D east = common.getOffsetToInertialDownlink().transformVector(Vector3D.PLUS_I);
        Vector3D north = common.getOffsetToInertialDownlink().transformVector(Vector3D.PLUS_J);
        Vector3D zenith = common.getOffsetToInertialDownlink().transformVector(Vector3D.PLUS_K);
        Vector3D staSat = transitPV.getPosition().subtract((Vector)common.getStationDownlink().getPosition());
        double baseAzimuth = FastMath.atan2((double)staSat.dotProduct((Vector)east), (double)staSat.dotProduct((Vector)north));
        double twoPiWrap = MathUtils.normalizeAngle((double)baseAzimuth, (double)this.getObservedValue()[0]) - baseAzimuth;
        double azimuth = baseAzimuth + twoPiWrap;
        double elevation = FastMath.asin((double)(staSat.dotProduct((Vector)zenith) / staSat.getNorm()));
        EstimatedMeasurementBase<AngularAzEl> estimated = new EstimatedMeasurementBase<AngularAzEl>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV, common.getStationDownlink()});
        estimated.setEstimatedValue(azimuth, elevation);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<AngularAzEl> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        TimeStampedFieldPVCoordinates<Gradient> transitPV = common.getTransitPV();
        GradientField field = common.getTauD().getField();
        FieldVector3D<Gradient> east = common.getOffsetToInertialDownlink().transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusI((Field)field));
        FieldVector3D<Gradient> north = common.getOffsetToInertialDownlink().transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusJ((Field)field));
        FieldVector3D<Gradient> zenith = common.getOffsetToInertialDownlink().transformVector((FieldVector3D<Gradient>)FieldVector3D.getPlusK((Field)field));
        FieldVector3D staSat = transitPV.getPosition().subtract(common.getStationDownlink().getPosition());
        Gradient baseAzimuth = ((Gradient)staSat.dotProduct(east)).atan2((Gradient)staSat.dotProduct(north));
        double twoPiWrap = MathUtils.normalizeAngle((double)baseAzimuth.getReal(), (double)this.getObservedValue()[0]) - baseAzimuth.getReal();
        Gradient azimuth = (Gradient)baseAzimuth.add(twoPiWrap);
        Gradient elevation = (Gradient)((Gradient)staSat.dotProduct(zenith)).divide((Gradient)staSat.getNorm()).asin();
        EstimatedMeasurement<AngularAzEl> estimated = new EstimatedMeasurement<AngularAzEl>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{transitPV.toTimeStampedPVCoordinates(), common.getStationDownlink().toTimeStampedPVCoordinates()});
        estimated.setEstimatedValue(azimuth.getValue(), elevation.getValue());
        double[] azDerivatives = azimuth.getGradient();
        double[] elDerivatives = elevation.getGradient();
        estimated.setStateDerivatives(0, Arrays.copyOfRange(azDerivatives, 0, 6), Arrays.copyOfRange(elDerivatives, 0, 6));
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), azDerivatives[index], elDerivatives[index]);
            }
        }
        return estimated;
    }

    public Vector3D getObservedLineOfSight(Frame outputFrame) {
        return this.getStation().getBaseFrame().getStaticTransformTo(outputFrame, this.getDate()).transformVector(new Vector3D(1.5707963267948966 - this.getObservedValue()[0], this.getObservedValue()[1]));
    }
}

