/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class DSSTBatchLSModel
extends AbstractBatchLSModel {
    private static final String STM_NAME = DSSTBatchLSModel.class.getName() + "-derivatives";
    private PropagationType propagationType;

    public DSSTBatchLSModel(PropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer, PropagationType propagationType) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, observer);
        this.propagationType = propagationType;
    }

    @Override
    protected MatricesHarvester configureHarvester(Propagator propagator) {
        return propagator.setupMatricesComputation(STM_NAME, null, null);
    }

    @Override
    protected Orbit configureOrbits(MatricesHarvester harvester, Propagator propagator) {
        DSSTPropagator dsstPropagator = (DSSTPropagator)propagator;
        SpacecraftState initial = dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(dsstPropagator.getInitialState(), dsstPropagator.getAttitudeProvider(), dsstPropagator.getAllForceModels()) : dsstPropagator.getInitialState();
        harvester.setReferenceState(initial);
        return initial.getOrbit();
    }
}

