/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.hipparchus.util.Incrementor;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.BatchLSObserver;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationsProvider;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeSpanMap;

public class BatchLSEstimator {
    private final PropagatorBuilder[] builders;
    private final List<ObservedMeasurement<?>> measurements;
    private final LeastSquaresOptimizer optimizer;
    private ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker;
    private final LeastSquaresBuilder lsBuilder;
    private BatchLSObserver observer;
    private Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> estimations;
    private Orbit[] orbits;
    private LeastSquaresOptimizer.Optimum optimum;
    private Incrementor evaluationsCounter;
    private Incrementor iterationsCounter;

    public BatchLSEstimator(LeastSquaresOptimizer optimizer, PropagatorBuilder ... propagatorBuilder) {
        this.builders = propagatorBuilder;
        this.measurements = new ArrayList();
        this.optimizer = optimizer;
        this.lsBuilder = new LeastSquaresBuilder();
        this.observer = null;
        this.estimations = null;
        this.orbits = new Orbit[this.builders.length];
        this.setParametersConvergenceThreshold(Double.NaN);
        this.lsBuilder.lazyEvaluation(false);
        this.lsBuilder.weight(null);
    }

    public void setObserver(BatchLSObserver observer) {
        this.observer = observer;
    }

    public void addMeasurement(ObservedMeasurement<?> measurement) {
        this.measurements.add(measurement);
    }

    public void setMaxIterations(int maxIterations) {
        this.lsBuilder.maxIterations(maxIterations);
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.lsBuilder.maxEvaluations(maxEvaluations);
    }

    public ParameterDriversList getOrbitalParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (int i = 0; i < this.builders.length; ++i) {
            String suffix = this.builders.length > 1 ? "[" + i + "]" : null;
            for (ParameterDriversList.DelegatingDriver delegating : this.builders[i].getOrbitalParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    if (suffix != null && !driver.getName().endsWith(suffix)) {
                        driver.setName(driver.getName() + suffix);
                    }
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public ParameterDriversList getPropagatorParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (PropagatorBuilder builder : this.builders) {
            for (ParameterDriversList.DelegatingDriver delegating : builder.getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public ParameterDriversList getMeasurementsParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList parameters = new ParameterDriversList();
        for (ObservedMeasurement<?> measurement : this.measurements) {
            for (ParameterDriver driver : measurement.getParametersDrivers()) {
                if (estimatedOnly && !driver.isSelected()) continue;
                parameters.add(driver);
            }
        }
        parameters.sort();
        return parameters;
    }

    public void setParametersConvergenceThreshold(double parametersConvergenceThreshold) {
        this.setConvergenceChecker((ConvergenceChecker<LeastSquaresProblem.Evaluation>)((ConvergenceChecker)(iteration, previous, current) -> current.getPoint().getLInfDistance(previous.getPoint()) <= parametersConvergenceThreshold));
    }

    public void setConvergenceChecker(ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker) {
        this.convergenceChecker = convergenceChecker;
    }

    /*
     * WARNING - void declaration
     */
    public Propagator[] estimate() {
        int spanNumber;
        for (ParameterDriver parameterDriver : this.getOrbitalParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        for (ParameterDriver parameterDriver : this.getPropagatorParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        for (ParameterDriver parameterDriver : this.getMeasurementsParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        ParameterDriversList estimatedOrbitalParameters = this.getOrbitalParametersDrivers(true);
        ParameterDriversList parameterDriversList = this.getPropagatorParametersDrivers(true);
        ParameterDriversList estimatedMeasurementsParameters = this.getMeasurementsParametersDrivers(true);
        double[] start = new double[estimatedOrbitalParameters.getNbValuesToEstimate() + parameterDriversList.getNbValuesToEstimate() + estimatedMeasurementsParameters.getNbValuesToEstimate()];
        int iStart = 0;
        for (ParameterDriver parameterDriver : estimatedOrbitalParameters.getDrivers()) {
            TimeSpanMap.Span<Double> span = parameterDriver.getValueSpanMap().getFirstSpan();
            start[iStart++] = parameterDriver.getNormalizedValue(span.getStart());
            for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                void var8_20;
                TimeSpanMap.Span<Double> span2 = parameterDriver.getValueSpanMap().getSpan(var8_20.getEnd());
                start[iStart++] = parameterDriver.getNormalizedValue(span2.getStart());
            }
        }
        for (ParameterDriver parameterDriver : parameterDriversList.getDrivers()) {
            TimeSpanMap.Span<Double> span = parameterDriver.getValueSpanMap().getFirstSpan();
            start[iStart++] = parameterDriver.getNormalizedValue(span.getStart());
            for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                void var8_25;
                TimeSpanMap.Span<Double> span3 = parameterDriver.getValueSpanMap().getSpan(var8_25.getEnd());
                start[iStart++] = parameterDriver.getNormalizedValue(span3.getStart());
            }
        }
        for (ParameterDriver parameterDriver : estimatedMeasurementsParameters.getDrivers()) {
            TimeSpanMap.Span<Double> span = parameterDriver.getValueSpanMap().getFirstSpan();
            start[iStart++] = parameterDriver.getNormalizedValue(span.getStart());
            for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                void var8_29;
                TimeSpanMap.Span<Double> span4 = parameterDriver.getValueSpanMap().getSpan(var8_29.getEnd());
                start[iStart++] = parameterDriver.getNormalizedValue(span4.getStart());
            }
        }
        this.lsBuilder.start(start);
        int p = 0;
        for (ObservedMeasurement<?> observedMeasurement : this.measurements) {
            if (!observedMeasurement.isEnabled()) continue;
            p += observedMeasurement.getDimension();
        }
        double[] dArray = new double[p];
        this.lsBuilder.target(dArray);
        ModelObserver modelObserver = new ModelObserver(){

            @Override
            public void modelCalled(Orbit[] newOrbits, Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> newEstimations) {
                BatchLSEstimator.access$002(BatchLSEstimator.this, newOrbits);
                BatchLSEstimator.this.estimations = newEstimations;
            }
        };
        AbstractBatchLSModel model = this.builders[0].buildLeastSquaresModel(this.builders, this.measurements, estimatedMeasurementsParameters, modelObserver);
        this.lsBuilder.model((MultivariateJacobianFunction)model);
        this.lsBuilder.parameterValidator((ParameterValidator)new Validator(estimatedOrbitalParameters, parameterDriversList, estimatedMeasurementsParameters));
        this.lsBuilder.checker(this.convergenceChecker);
        TappedLSProblem problem = new TappedLSProblem(this.lsBuilder.build(), model, estimatedOrbitalParameters, parameterDriversList, estimatedMeasurementsParameters);
        try {
            this.optimum = this.optimizer.optimize((LeastSquaresProblem)problem);
            return model.createPropagators(this.optimum.getPoint());
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> getLastEstimations() {
        return Collections.unmodifiableMap(this.estimations);
    }

    public LeastSquaresOptimizer.Optimum getOptimum() {
        return this.optimum;
    }

    /*
     * WARNING - void declaration
     */
    public RealMatrix getPhysicalCovariances(double threshold) {
        int i;
        RealMatrix covariances;
        try {
            covariances = this.optimum.getCovariances(threshold).copy();
        }
        catch (MathIllegalArgumentException miae) {
            throw new OrekitException((MathRuntimeException)((Object)miae));
        }
        double[] scale = new double[covariances.getRowDimension()];
        int index = 0;
        for (ParameterDriver parameterDriver : this.getOrbitalParametersDrivers(true).getDrivers()) {
            for (i = 0; i < parameterDriver.getNbOfValues(); ++i) {
                scale[index++] = parameterDriver.getScale();
            }
        }
        for (ParameterDriver parameterDriver : this.getPropagatorParametersDrivers(true).getDrivers()) {
            for (i = 0; i < parameterDriver.getNbOfValues(); ++i) {
                scale[index++] = parameterDriver.getScale();
            }
        }
        for (ParameterDriver parameterDriver : this.getMeasurementsParametersDrivers(true).getDrivers()) {
            for (i = 0; i < parameterDriver.getNbOfValues(); ++i) {
                scale[index++] = parameterDriver.getScale();
            }
        }
        for (int i2 = 0; i2 < covariances.getRowDimension(); ++i2) {
            void var7_14;
            boolean bl = false;
            while (var7_14 < covariances.getColumnDimension()) {
                covariances.setEntry(i2, (int)var7_14, scale[i2] * scale[var7_14] * covariances.getEntry(i2, (int)var7_14));
                ++var7_14;
            }
        }
        return covariances;
    }

    public int getIterationsCount() {
        return this.iterationsCounter.getCount();
    }

    public int getEvaluationsCount() {
        return this.evaluationsCounter.getCount();
    }

    static /* synthetic */ Orbit[] access$002(BatchLSEstimator x0, Orbit[] x1) {
        x0.orbits = x1;
        return x1;
    }

    private static class Validator
    implements ParameterValidator {
        private final ParameterDriversList estimatedOrbitalParameters;
        private final ParameterDriversList estimatedPropagatorParameters;
        private final ParameterDriversList estimatedMeasurementsParameters;

        Validator(ParameterDriversList estimatedOrbitalParameters, ParameterDriversList estimatedPropagatorParameters, ParameterDriversList estimatedMeasurementsParameters) {
            this.estimatedOrbitalParameters = estimatedOrbitalParameters;
            this.estimatedPropagatorParameters = estimatedPropagatorParameters;
            this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        }

        public RealVector validate(RealVector params) {
            AbsoluteDate modificationDate;
            int spanNumber;
            TimeSpanMap.Span<Double> span;
            int i = 0;
            for (ParameterDriver parameterDriver : this.estimatedOrbitalParameters.getDrivers()) {
                if (parameterDriver.getNbOfValues() == 1) {
                    parameterDriver.setNormalizedValue(params.getEntry(i), null);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(null));
                    continue;
                }
                span = parameterDriver.getValueSpanMap().getFirstSpan();
                parameterDriver.setNormalizedValue(params.getEntry(i), span.getStart());
                params.setEntry(i++, parameterDriver.getNormalizedValue(span.getStart()));
                for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                    modificationDate = span.getEnd();
                    span = parameterDriver.getValueSpanMap().getSpan(modificationDate);
                    parameterDriver.setNormalizedValue(params.getEntry(i), modificationDate);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(modificationDate));
                }
            }
            for (ParameterDriver parameterDriver : this.estimatedPropagatorParameters.getDrivers()) {
                if (parameterDriver.getNbOfValues() == 1) {
                    parameterDriver.setNormalizedValue(params.getEntry(i), null);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(null));
                    continue;
                }
                span = parameterDriver.getValueSpanMap().getFirstSpan();
                parameterDriver.setNormalizedValue(params.getEntry(i), span.getStart());
                params.setEntry(i++, parameterDriver.getNormalizedValue(span.getStart()));
                for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                    modificationDate = span.getEnd();
                    span = parameterDriver.getValueSpanMap().getSpan(modificationDate);
                    parameterDriver.setNormalizedValue(params.getEntry(i), modificationDate);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(modificationDate));
                }
            }
            for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
                if (parameterDriver.getNbOfValues() == 1) {
                    parameterDriver.setNormalizedValue(params.getEntry(i), null);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(null));
                    continue;
                }
                span = parameterDriver.getValueSpanMap().getFirstSpan();
                parameterDriver.setNormalizedValue(params.getEntry(i), span.getStart());
                params.setEntry(i++, parameterDriver.getNormalizedValue(span.getStart()));
                for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues() - 1; ++spanNumber) {
                    modificationDate = span.getEnd();
                    span = parameterDriver.getValueSpanMap().getSpan(modificationDate);
                    parameterDriver.setNormalizedValue(params.getEntry(i), modificationDate);
                    params.setEntry(i++, parameterDriver.getNormalizedValue(modificationDate));
                }
            }
            return params;
        }
    }

    private class Provider
    implements EstimationsProvider {
        private EstimatedMeasurement<?>[] sortedEstimations;

        private Provider() {
        }

        @Override
        public int getNumber() {
            return BatchLSEstimator.this.estimations.size();
        }

        @Override
        public EstimatedMeasurement<?> getEstimatedMeasurement(int index) {
            if (index < 0 || index >= BatchLSEstimator.this.estimations.size()) {
                throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, 0, BatchLSEstimator.this.estimations.size());
            }
            if (this.sortedEstimations == null) {
                this.sortedEstimations = new EstimatedMeasurement[BatchLSEstimator.this.estimations.size()];
                int i = 0;
                for (Map.Entry entry : BatchLSEstimator.this.estimations.entrySet()) {
                    this.sortedEstimations[i++] = (EstimatedMeasurement)entry.getValue();
                }
                Arrays.sort(this.sortedEstimations, 0, this.sortedEstimations.length, Comparator.naturalOrder());
            }
            return this.sortedEstimations[index];
        }
    }

    private class TappedLSProblem
    implements LeastSquaresProblem {
        private final LeastSquaresProblem problem;
        private final AbstractBatchLSModel model;
        private final ParameterDriversList estimatedOrbitalParameters;
        private final ParameterDriversList estimatedPropagatorParameters;
        private final ParameterDriversList estimatedMeasurementsParameters;

        TappedLSProblem(LeastSquaresProblem problem, AbstractBatchLSModel model, ParameterDriversList estimatedOrbitalParameters, ParameterDriversList estimatedPropagatorParameters, ParameterDriversList estimatedMeasurementsParameters) {
            this.problem = problem;
            this.model = model;
            this.estimatedOrbitalParameters = estimatedOrbitalParameters;
            this.estimatedPropagatorParameters = estimatedPropagatorParameters;
            this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        }

        public Incrementor getEvaluationCounter() {
            BatchLSEstimator.this.evaluationsCounter = this.problem.getEvaluationCounter();
            this.model.setEvaluationsCounter(BatchLSEstimator.this.evaluationsCounter);
            return BatchLSEstimator.this.evaluationsCounter;
        }

        public Incrementor getIterationCounter() {
            BatchLSEstimator.this.iterationsCounter = this.problem.getIterationCounter();
            this.model.setIterationsCounter(BatchLSEstimator.this.iterationsCounter);
            return BatchLSEstimator.this.iterationsCounter;
        }

        public ConvergenceChecker<LeastSquaresProblem.Evaluation> getConvergenceChecker() {
            return this.problem.getConvergenceChecker();
        }

        public RealVector getStart() {
            return this.problem.getStart();
        }

        public int getObservationSize() {
            return this.problem.getObservationSize();
        }

        public int getParameterSize() {
            return this.problem.getParameterSize();
        }

        public LeastSquaresProblem.Evaluation evaluate(RealVector point) {
            LeastSquaresProblem.Evaluation evaluation = this.problem.evaluate(point);
            if (BatchLSEstimator.this.observer != null) {
                BatchLSEstimator.this.observer.evaluationPerformed(BatchLSEstimator.this.iterationsCounter.getCount(), BatchLSEstimator.this.evaluationsCounter.getCount(), BatchLSEstimator.this.orbits, this.estimatedOrbitalParameters, this.estimatedPropagatorParameters, this.estimatedMeasurementsParameters, new Provider(), evaluation);
            }
            return evaluation;
        }
    }
}

