/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.analysis.solvers.LaguerreSolver;
import org.hipparchus.complex.Complex;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodLaplace {
    private final double mu;

    public IodLaplace(double mu) {
        this.mu = mu;
    }

    public Orbit estimate(Frame outputFrame, AngularAzEl azEl1, AngularAzEl azEl2, AngularAzEl azEl3) {
        return this.estimate(outputFrame, azEl2.getGroundStationCoordinates(outputFrame), azEl1.getDate(), azEl1.getObservedLineOfSight(outputFrame), azEl2.getDate(), azEl2.getObservedLineOfSight(outputFrame), azEl3.getDate(), azEl3.getObservedLineOfSight(outputFrame));
    }

    public Orbit estimate(Frame outputFrame, AngularRaDec raDec1, AngularRaDec raDec2, AngularRaDec raDec3) {
        return this.estimate(outputFrame, raDec2.getGroundStationCoordinates(outputFrame), raDec1.getDate(), raDec1.getObservedLineOfSight(outputFrame), raDec2.getDate(), raDec2.getObservedLineOfSight(outputFrame), raDec3.getDate(), raDec3.getObservedLineOfSight(outputFrame));
    }

    public Orbit estimate(Frame outputFrame, PVCoordinates obsPva, AbsoluteDate obsDate1, Vector3D los1, AbsoluteDate obsDate2, Vector3D los2, AbsoluteDate obsDate3, Vector3D los3) {
        Vector3D Ldotdot;
        double t3;
        double t2 = obsDate2.durationFrom(obsDate1);
        Vector3D Ldot = los1.scalarMultiply((t2 - (t3 = obsDate3.durationFrom(obsDate1))) / (t2 * t3)).add((Vector)los2.scalarMultiply((2.0 * t2 - t3) / (t2 * (t2 - t3)))).add((Vector)los3.scalarMultiply(t2 / (t3 * (t3 - t2))));
        double D = 2.0 * this.getDeterminant(los2, Ldot, Ldotdot = los1.scalarMultiply(2.0 / (t2 * t3)).add((Vector)los2.scalarMultiply(2.0 / (t2 * (t2 - t3)))).add((Vector)los3.scalarMultiply(2.0 / (t3 * (t3 - t2)))));
        if (FastMath.abs((double)D) < 1.0E-14) {
            return null;
        }
        double Dsq = D * D;
        double R = obsPva.getPosition().getNorm();
        double RdotL = obsPva.getPosition().dotProduct((Vector)los2);
        double D1 = this.getDeterminant(los2, Ldot, obsPva.getAcceleration());
        double D2 = this.getDeterminant(los2, Ldot, obsPva.getPosition());
        double[] coeff = new double[]{-4.0 * this.mu * this.mu * D2 * D2 / Dsq, 0.0, 0.0, 4.0 * this.mu * D2 * (RdotL / D - 2.0 * D1 / Dsq), 0.0, 0.0, 4.0 * D1 * RdotL / D - 4.0 * D1 * D1 / Dsq - R * R, 0.0, 1.0};
        LaguerreSolver solver = new LaguerreSolver(1.0E-10, 1.0E-10, 1.0E-10);
        Complex[] roots = solver.solveAllComplex(coeff, 5.0 * R);
        double rMag = 0.0;
        for (Complex root : roots) {
            if (!(root.getReal() > rMag) || !(FastMath.abs((double)root.getImaginary()) < solver.getAbsoluteAccuracy())) continue;
            rMag = root.getReal();
        }
        if (rMag == 0.0) {
            return null;
        }
        double rCubed = rMag * rMag * rMag;
        double rho = -2.0 * D1 / D - 2.0 * this.mu * D2 / (D * rCubed);
        Vector3D posVec = los2.scalarMultiply(rho).add((Vector)obsPva.getPosition());
        double D3 = this.getDeterminant(los2, obsPva.getAcceleration(), Ldotdot);
        double D4 = this.getDeterminant(los2, obsPva.getPosition(), Ldotdot);
        double rhoDot = -D3 / D - this.mu * D4 / (D * rCubed);
        Vector3D velVec = los2.scalarMultiply(rhoDot).add((Vector)Ldot.scalarMultiply(rho)).add((Vector)obsPva.getVelocity());
        return new CartesianOrbit(new PVCoordinates(posVec, velVec), outputFrame, obsDate2, this.mu);
    }

    private double getDeterminant(Vector3D col0, Vector3D col1, Vector3D col2) {
        Array2DRowRealMatrix mat = new Array2DRowRealMatrix(3, 3);
        mat.setColumn(0, col0.toArray());
        mat.setColumn(1, col1.toArray());
        mat.setColumn(2, col2.toArray());
        return new LUDecomposition((RealMatrix)mat).getDeterminant();
    }
}

