/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.Position;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodGibbs {
    private final double mu;
    private final double COPLANAR_THRESHOLD = FastMath.toRadians((double)5.0);

    public IodGibbs(double mu) {
        this.mu = mu;
    }

    public Orbit estimate(Frame frame, Position p1, Position p2, Position p3) {
        return this.estimate(frame, p1.getPosition(), p1.getDate(), p2.getPosition(), p2.getDate(), p3.getPosition(), p3.getDate());
    }

    public Orbit estimate(Frame frame, PV pv1, PV pv2, PV pv3) {
        return this.estimate(frame, pv1.getPosition(), pv1.getDate(), pv2.getPosition(), pv2.getDate(), pv3.getPosition(), pv3.getDate());
    }

    public Orbit estimate(Frame frame, Vector3D r1, AbsoluteDate date1, Vector3D r2, AbsoluteDate date2, Vector3D r3, AbsoluteDate date3) {
        Vector3D estP3_2;
        double dist2;
        if (date1.equals(date2) || date1.equals(date3) || date2.equals(date3)) {
            throw new OrekitException((Localizable)OrekitMessages.NON_DIFFERENT_DATES_FOR_OBSERVATIONS, date1, date2, date3, date2.durationFrom(date1), date3.durationFrom(date1), date3.durationFrom(date2));
        }
        double num = ((Vector3D)r1.normalize()).dotProduct((Vector)((Vector3D)r2.normalize()).crossProduct(r3.normalize()));
        double alpha = 1.5707963267948966 - FastMath.acos((double)num);
        if (FastMath.abs((double)alpha) > this.COPLANAR_THRESHOLD) {
            throw new OrekitException((Localizable)OrekitMessages.NON_COPLANAR_POINTS, new Object[0]);
        }
        Vector3D D = r1.crossProduct((Vector)r2).add((Vector)r2.crossProduct((Vector)r3).add((Vector)r3.crossProduct((Vector)r1)));
        Vector3D N = r2.crossProduct((Vector)r3).scalarMultiply(r1.getNorm()).add((Vector)r3.crossProduct((Vector)r1).scalarMultiply(r2.getNorm())).add((Vector)r1.crossProduct((Vector)r2).scalarMultiply(r3.getNorm()));
        Vector3D B = D.crossProduct((Vector)r2);
        Vector3D S = r1.scalarMultiply(r2.getNorm() - r3.getNorm()).add((Vector)r2.scalarMultiply(r3.getNorm() - r1.getNorm()).add((Vector)r3.scalarMultiply(r1.getNorm() - r2.getNorm())));
        double vm = FastMath.sqrt((double)(this.mu / (N.getNorm() * D.getNorm())));
        Vector3D vlEci = B.scalarMultiply(vm / r2.getNorm()).add((Vector)S.scalarMultiply(vm));
        PVCoordinates pv = new PVCoordinates(r2, vlEci);
        CartesianOrbit orbit = new CartesianOrbit(pv, frame, date2, this.mu);
        PVCoordinates pv2 = new PVCoordinates(r2, vlEci.scalarMultiply(-1.0));
        CartesianOrbit orbit2 = new CartesianOrbit(pv2, frame, date2, this.mu);
        Vector3D estP3 = orbit.shiftedBy(date3.durationFrom(date2)).getPosition();
        double dist = estP3.subtract((Vector)r3).getNorm();
        if (dist <= (dist2 = (estP3_2 = orbit2.shiftedBy(date3.durationFrom(date2)).getPosition()).subtract((Vector)r3).getNorm())) {
            return orbit;
        }
        return orbit2;
    }
}

