/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.analysis.solvers.LaguerreSolver;
import org.hipparchus.complex.Complex;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodGauss {
    private final double mu;

    public IodGauss(double mu) {
        this.mu = mu;
    }

    public Orbit estimate(Frame outputFrame, AngularAzEl azEl1, AngularAzEl azEl2, AngularAzEl azEl3) {
        return this.estimate(outputFrame, azEl1.getGroundStationPosition(outputFrame), azEl1.getDate(), azEl1.getObservedLineOfSight(outputFrame), azEl2.getGroundStationPosition(outputFrame), azEl2.getDate(), azEl2.getObservedLineOfSight(outputFrame), azEl3.getGroundStationPosition(outputFrame), azEl3.getDate(), azEl3.getObservedLineOfSight(outputFrame));
    }

    public Orbit estimate(Frame outputFrame, AngularRaDec raDec1, AngularRaDec raDec2, AngularRaDec raDec3) {
        return this.estimate(outputFrame, raDec1.getGroundStationPosition(outputFrame), raDec1.getDate(), raDec1.getObservedLineOfSight(outputFrame), raDec2.getGroundStationPosition(outputFrame), raDec2.getDate(), raDec2.getObservedLineOfSight(outputFrame), raDec3.getGroundStationPosition(outputFrame), raDec3.getDate(), raDec3.getObservedLineOfSight(outputFrame));
    }

    public Orbit estimate(Frame outputFrame, Vector3D obsP1, AbsoluteDate obsDate1, Vector3D los1, Vector3D obsP2, AbsoluteDate obsDate2, Vector3D los2, Vector3D obsP3, AbsoluteDate obsDate3, Vector3D los3) {
        double tau1 = obsDate1.getDate().durationFrom(obsDate2.getDate());
        double tau3 = obsDate3.getDate().durationFrom(obsDate2.getDate());
        double diffTau3Tau1 = tau3 - tau1;
        double a1 = tau3 / diffTau3Tau1;
        double a3 = -tau1 / diffTau3Tau1;
        double a1u = tau3 * (diffTau3Tau1 * diffTau3Tau1 - tau3 * tau3) / (6.0 * diffTau3Tau1);
        double a3u = -tau1 * (diffTau3Tau1 * diffTau3Tau1 - tau1 * tau1) / (6.0 * diffTau3Tau1);
        Array2DRowRealMatrix losMatrix = new Array2DRowRealMatrix(3, 3);
        losMatrix.setColumn(0, los1.toArray());
        losMatrix.setColumn(1, los2.toArray());
        losMatrix.setColumn(2, los3.toArray());
        RealMatrix invertedLosMatrix = new LUDecomposition((RealMatrix)losMatrix).getSolver().getInverse();
        Array2DRowRealMatrix rSite = new Array2DRowRealMatrix(3, 3);
        rSite.setColumn(0, obsP1.toArray());
        rSite.setColumn(1, obsP2.toArray());
        rSite.setColumn(2, obsP3.toArray());
        RealMatrix m = invertedLosMatrix.multiply((RealMatrix)rSite);
        double d1 = m.getEntry(1, 0) * a1 - m.getEntry(1, 1) + m.getEntry(1, 2) * a3;
        double d2 = m.getEntry(1, 0) * a1u + m.getEntry(1, 2) * a3u;
        double C = los2.dotProduct((Vector)obsP2);
        double r2Norm = obsP2.getNorm();
        double[] coeff = new double[]{-this.mu * this.mu * d2 * d2, 0.0, 0.0, -2.0 * this.mu * (C * d2 + d1 * d2), 0.0, 0.0, -(d1 * d1 + 2.0 * C * d1 + r2Norm * r2Norm), 0.0, 1.0};
        LaguerreSolver solver = new LaguerreSolver(1.0E-10, 1.0E-10, 1.0E-10);
        Complex[] roots = solver.solveAllComplex(coeff, 5.0 * r2Norm);
        double r2Mag = 0.0;
        for (Complex root : roots) {
            if (!(root.getReal() > r2Mag) || !(FastMath.abs((double)root.getImaginary()) < solver.getAbsoluteAccuracy())) continue;
            r2Mag = root.getReal();
        }
        if (r2Mag == 0.0) {
            return null;
        }
        double u = this.mu / (r2Mag * r2Mag * r2Mag);
        double c1 = -(-a1 - a1u * u);
        double c2 = -1.0;
        double c3 = -(-a3 - a3u * u);
        Array2DRowRealMatrix cCoeffMatrix = new Array2DRowRealMatrix(3, 1);
        cCoeffMatrix.setEntry(0, 0, -c1);
        cCoeffMatrix.setEntry(1, 0, 1.0);
        cCoeffMatrix.setEntry(2, 0, -c3);
        RealMatrix B = m.multiply(cCoeffMatrix.scalarMultiply(1.0));
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(3, 3);
        A.setEntry(0, 0, c1);
        A.setEntry(1, 1, -1.0);
        A.setEntry(2, 2, c3);
        RealMatrix slantRanges = new LUDecomposition((RealMatrix)A).getSolver().solve(B);
        Array2DRowRealMatrix posMatrix = new Array2DRowRealMatrix(3, 3);
        for (int i = 0; i <= 2; ++i) {
            RealVector position = losMatrix.getColumnVector(i).mapMultiply(slantRanges.getEntry(i, 0)).add(rSite.getColumnVector(i));
            posMatrix.setRowVector(i, position);
        }
        double pos2Norm = posMatrix.getRowVector(1).getNorm();
        double pos2NormCubed = pos2Norm * pos2Norm * pos2Norm;
        double f1 = 1.0 - 0.5 * this.mu * tau1 * tau1 / pos2NormCubed;
        double f3 = 1.0 - 0.5 * this.mu * tau3 * tau3 / pos2NormCubed;
        double g1 = tau1 - 0.16666666666666666 * this.mu * tau1 * tau1 * tau1 / pos2NormCubed;
        double g3 = tau3 - 0.16666666666666666 * this.mu * tau3 * tau3 * tau3 / pos2NormCubed;
        double v2EquationCoeff = 1.0 / (f1 * g3 - f3 * g1);
        RealVector v2 = posMatrix.getRowVector(0).mapMultiply(-f3).add(posMatrix.getRowVector(2).mapMultiply(f1)).mapMultiply(v2EquationCoeff);
        RealVector p2 = posMatrix.getRowVector(1);
        Vector3D p2Vector3D = new Vector3D(p2.toArray());
        Vector3D v2Vector3D = new Vector3D(v2.toArray());
        return new CartesianOrbit(new PVCoordinates(p2Vector3D, v2Vector3D), outputFrame, obsDate2, this.mu);
    }
}

