/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.errors;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.ParameterDriver;

public class UnsupportedParameterException
extends OrekitException {
    public static final String NO_PARAMETER = "<none>";
    public static final String COMMA_SEP = ", ";
    private static final long serialVersionUID = -1363569710782876135L;

    public UnsupportedParameterException(String parameterName, List<ParameterDriver> parameterDrivers) {
        super((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, parameterName, UnsupportedParameterException.getSupportedNames(parameterDrivers));
    }

    private static String getSupportedNames(List<ParameterDriver> parameterDrivers) {
        StringBuilder builder = new StringBuilder();
        for (ParameterDriver driver : parameterDrivers) {
            if (builder.length() > 0) {
                builder.append(COMMA_SEP);
            }
            builder.append(driver.getName());
        }
        if (builder.length() == 0) {
            builder.append(NO_PARAMETER);
        }
        return builder.toString();
    }
}

