/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataFilter;
import org.orekit.data.DataSource;

public class TruncatingFilter
implements DataFilter {
    private final int nbLines;

    public TruncatingFilter(int nbLines) {
        this.nbLines = nbLines;
    }

    @Override
    public DataSource filter(DataSource original) throws IOException {
        return new DataSource(original.getName() + "-truncated-after-line-" + this.nbLines, () -> new TruncatingReader(original.getOpener().openReaderOnce()));
    }

    private class TruncatingReader
    extends Reader {
        private final BufferedReader reader;
        private int linesRead;
        private String pending;
        private int countOut;

        TruncatingReader(Reader reader) {
            this.reader = new BufferedReader(reader);
        }

        @Override
        public int read(char[] b, int offset, int len) throws IOException {
            if (this.linesRead < TruncatingFilter.this.nbLines) {
                if (this.pending == null) {
                    this.countOut = 0;
                    this.pending = this.reader.readLine();
                    if (this.pending == null) {
                        return -1;
                    }
                }
                int n = FastMath.min((int)len, (int)(this.pending.length() - this.countOut));
                for (int i = 0; i < n; ++i) {
                    b[offset + i] = this.pending.charAt(this.countOut + i);
                }
                if (n < len) {
                    b[offset + n] = 10;
                    ++this.linesRead;
                    this.pending = null;
                    return ++n;
                }
                this.countOut += n;
                return n;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

