/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.hipparchus.util.FastMath;

public abstract class LineOrientedFilteringReader
extends Reader {
    private final BufferedReader reader;
    private int lastLineNumber;
    private CharSequence pending;
    private int countOut;

    public LineOrientedFilteringReader(String name, Reader input) throws IOException {
        this.reader = new BufferedReader(input);
        this.lastLineNumber = 0;
    }

    protected BufferedReader getBufferedReader() {
        return this.reader;
    }

    @Override
    public int read(char[] b, int offset, int len) throws IOException {
        if (this.pending == null) {
            this.countOut = 0;
            String originalLine = this.reader.readLine();
            ++this.lastLineNumber;
            if (originalLine == null) {
                return -1;
            }
            this.pending = this.filterLine(this.lastLineNumber, originalLine);
        }
        int n = FastMath.min((int)len, (int)(this.pending.length() - this.countOut));
        for (int i = 0; i < n; ++i) {
            b[offset + i] = this.pending.charAt(this.countOut + i);
        }
        if (n < len) {
            b[offset + n] = 10;
            this.pending = null;
            ++n;
        } else {
            this.countOut += n;
        }
        return n;
    }

    protected abstract CharSequence filterLine(int var1, String var2) throws IOException;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

