/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.zip.GZIPInputStream;
import org.orekit.data.DataFilter;
import org.orekit.data.DataSource;

public class GzipFilter
implements DataFilter {
    private static final String SUFFIX = ".gz";

    @Override
    public DataSource filter(DataSource original) {
        String oName = original.getName();
        DataSource.Opener oOpener = original.getOpener();
        if (oName.endsWith(SUFFIX)) {
            String fName = oName.substring(0, oName.length() - SUFFIX.length());
            DataSource.StreamOpener fOpener = () -> new GZIPInputStream(oOpener.openStreamOnce());
            return new DataSource(fName, fOpener);
        }
        return original;
    }
}

