/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.shooting.propagation;

import java.util.List;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.control.indirect.shooting.propagation.AdjointDynamicsProvider;
import org.orekit.control.indirect.shooting.propagation.ShootingIntegrationSettings;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;

public class ShootingPropagationSettings {
    private final List<ForceModel> forceModels;
    private final AdjointDynamicsProvider adjointDynamicsProvider;
    private final AttitudeProvider attitudeProvider;
    private final Frame propagationFrame;
    private final ShootingIntegrationSettings integrationSettings;

    @DefaultDataContext
    public ShootingPropagationSettings(List<ForceModel> forceModels, AdjointDynamicsProvider adjointDynamicsProvider, ShootingIntegrationSettings integrationSettings) {
        this(forceModels, adjointDynamicsProvider, FramesFactory.getGCRF(), integrationSettings, AttitudeProviderModifier.getFrozenAttitudeProvider(new FrameAlignedProvider(FramesFactory.getGCRF())));
    }

    public ShootingPropagationSettings(List<ForceModel> forceModels, AdjointDynamicsProvider adjointDynamicsProvider, Frame propagationFrame, ShootingIntegrationSettings integrationSettings, AttitudeProvider attitudeProvider) {
        this.forceModels = forceModels;
        this.adjointDynamicsProvider = adjointDynamicsProvider;
        this.propagationFrame = propagationFrame;
        this.integrationSettings = integrationSettings;
        this.attitudeProvider = attitudeProvider;
    }

    public AdjointDynamicsProvider getAdjointDynamicsProvider() {
        return this.adjointDynamicsProvider;
    }

    public List<ForceModel> getForceModels() {
        return this.forceModels;
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    public Frame getPropagationFrame() {
        return this.propagationFrame;
    }

    public ShootingIntegrationSettings getIntegrationSettings() {
        return this.integrationSettings;
    }
}

