/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.shooting.boundary;

import org.hipparchus.geometry.Vector;
import org.hipparchus.util.FastMath;
import org.orekit.control.indirect.shooting.boundary.CartesianBoundaryConditionChecker;
import org.orekit.utils.PVCoordinates;

public class NormBasedCartesianConditionChecker
implements CartesianBoundaryConditionChecker {
    private final int maximumIterationCount;
    private final double absoluteToleranceDistance;
    private final double absoluteToleranceSpeed;

    public NormBasedCartesianConditionChecker(int maximumIterationCount, double absoluteToleranceDistance, double absoluteToleranceSpeed) {
        this.maximumIterationCount = maximumIterationCount;
        this.absoluteToleranceDistance = FastMath.abs((double)absoluteToleranceDistance);
        this.absoluteToleranceSpeed = FastMath.abs((double)absoluteToleranceSpeed);
    }

    @Override
    public int getMaximumIterationCount() {
        return this.maximumIterationCount;
    }

    @Override
    public boolean isConverged(PVCoordinates targetPV, PVCoordinates actualPV) {
        return targetPV.getPosition().subtract((Vector)actualPV.getPosition()).getNorm() < this.absoluteToleranceDistance && targetPV.getVelocity().subtract((Vector)actualPV.getVelocity()).getNorm() < this.absoluteToleranceSpeed;
    }
}

