/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.shooting;

import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.control.indirect.shooting.AbstractFixedBoundaryCartesianSingleShooting;
import org.orekit.control.indirect.shooting.boundary.CartesianBoundaryConditionChecker;
import org.orekit.control.indirect.shooting.boundary.FixedTimeBoundaryOrbits;
import org.orekit.control.indirect.shooting.boundary.FixedTimeCartesianBoundaryStates;
import org.orekit.control.indirect.shooting.propagation.ShootingPropagationSettings;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class NewtonFixedBoundaryCartesianSingleShooting
extends AbstractFixedBoundaryCartesianSingleShooting {
    public NewtonFixedBoundaryCartesianSingleShooting(ShootingPropagationSettings propagationSettings, FixedTimeCartesianBoundaryStates boundaryConditions, CartesianBoundaryConditionChecker convergenceChecker) {
        super(propagationSettings, boundaryConditions, convergenceChecker);
    }

    public NewtonFixedBoundaryCartesianSingleShooting(ShootingPropagationSettings propagationSettings, FixedTimeBoundaryOrbits boundaryConditions, CartesianBoundaryConditionChecker convergenceChecker) {
        super(propagationSettings, boundaryConditions, convergenceChecker);
    }

    @Override
    protected double[] updateAdjoint(double[] originalInitialAdjoint, FieldSpacecraftState<Gradient> fieldTerminalState) {
        double[] defects = new double[originalInitialAdjoint.length];
        double[][] defectsJacobianData = new double[defects.length][defects.length];
        double reciprocalScalePosition = 1.0 / this.getScalePositionDefects();
        double reciprocalScaleVelocity = 1.0 / this.getScaleVelocityDefects();
        TimeStampedFieldPVCoordinates<Gradient> terminalPV = fieldTerminalState.getPVCoordinates();
        FieldVector3D fieldScaledTerminalPosition = terminalPV.getPosition().scalarMultiply(reciprocalScalePosition);
        FieldVector3D fieldScaledTerminalVelocity = terminalPV.getVelocity().scalarMultiply(reciprocalScaleVelocity);
        Vector3D terminalScaledPosition = fieldScaledTerminalPosition.toVector3D();
        Vector3D terminalScaledVelocity = fieldScaledTerminalVelocity.toVector3D();
        Vector3D targetScaledPosition = this.getTerminalCartesianState().getPosition().scalarMultiply(reciprocalScalePosition);
        Vector3D targetScaledVelocity = this.getTerminalCartesianState().getVelocity().scalarMultiply(reciprocalScaleVelocity);
        defects[0] = terminalScaledPosition.getX() - targetScaledPosition.getX();
        defectsJacobianData[0] = ((Gradient)fieldScaledTerminalPosition.getX()).getGradient();
        defects[1] = terminalScaledPosition.getY() - targetScaledPosition.getY();
        defectsJacobianData[1] = ((Gradient)fieldScaledTerminalPosition.getY()).getGradient();
        defects[2] = terminalScaledPosition.getZ() - targetScaledPosition.getZ();
        defectsJacobianData[2] = ((Gradient)fieldScaledTerminalPosition.getZ()).getGradient();
        defects[3] = terminalScaledVelocity.getX() - targetScaledVelocity.getX();
        defectsJacobianData[3] = ((Gradient)fieldScaledTerminalVelocity.getX()).getGradient();
        defects[4] = terminalScaledVelocity.getY() - targetScaledVelocity.getY();
        defectsJacobianData[4] = ((Gradient)fieldScaledTerminalVelocity.getY()).getGradient();
        defects[5] = terminalScaledVelocity.getZ() - targetScaledVelocity.getZ();
        defectsJacobianData[5] = ((Gradient)fieldScaledTerminalVelocity.getZ()).getGradient();
        if (originalInitialAdjoint.length != 6) {
            String adjointName = this.getPropagationSettings().getAdjointDynamicsProvider().getAdjointName();
            Gradient terminalMassAdjoint = ((Gradient[])fieldTerminalState.getAdditionalState(adjointName))[6];
            defects[6] = terminalMassAdjoint.getValue();
            defectsJacobianData[6] = terminalMassAdjoint.getGradient();
        }
        double[] correction = this.computeCorrection(defects, defectsJacobianData);
        double[] correctedAdjoint = (double[])originalInitialAdjoint.clone();
        for (int i = 0; i < correction.length; ++i) {
            int n = i;
            correctedAdjoint[n] = correctedAdjoint[n] + correction[i];
        }
        return correctedAdjoint;
    }

    private double[] computeCorrection(double[] defects, double[][] defectsJacobianData) {
        RealMatrix defectsJacobian = MatrixUtils.createRealMatrix((double[][])defectsJacobianData);
        DecompositionSolver solver = new LUDecomposition(defectsJacobian).getSolver();
        RealVector negatedDefects = MatrixUtils.createRealVector((double[])defects).mapMultiply(-1.0);
        return solver.solve(negatedDefects).toArray();
    }
}

