/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.shooting;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.control.indirect.shooting.ShootingBoundaryOutput;
import org.orekit.control.indirect.shooting.propagation.ShootingPropagationSettings;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.FieldODEIntegratorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.FieldAdditionalDerivativesProvider;
import org.orekit.propagation.numerical.FieldNumericalPropagator;
import org.orekit.propagation.numerical.NumericalPropagator;

public abstract class AbstractIndirectShooting {
    public static final double DEFAULT_TOLERANCE_MASS_ADJOINT = 1.0E-10;
    private final ShootingPropagationSettings propagationSettings;

    protected AbstractIndirectShooting(ShootingPropagationSettings propagationSettings) {
        this.propagationSettings = propagationSettings;
    }

    public ShootingPropagationSettings getPropagationSettings() {
        return this.propagationSettings;
    }

    public abstract ShootingBoundaryOutput solve(double var1, double[] var3);

    protected NumericalPropagator buildPropagator(SpacecraftState initialState) {
        ODEIntegrator integrator = this.buildIntegrator(initialState);
        NumericalPropagator propagator = new NumericalPropagator(integrator, this.propagationSettings.getAttitudeProvider());
        propagator.setIgnoreCentralAttraction(true);
        propagator.setInitialState(initialState);
        propagator.setIgnoreCentralAttraction(false);
        propagator.removeForceModels();
        if (initialState.isOrbitDefined()) {
            propagator.setOrbitType(initialState.getOrbit().getType());
        } else {
            if (this.propagationSettings.getForceModels().stream().noneMatch(NewtonianAttraction.class::isInstance)) {
                propagator.setIgnoreCentralAttraction(true);
            }
            propagator.setOrbitType(null);
        }
        for (ForceModel forceModel : this.propagationSettings.getForceModels()) {
            propagator.addForceModel(forceModel);
        }
        AdditionalDerivativesProvider derivativesProvider = this.propagationSettings.getAdjointDynamicsProvider().buildAdditionalDerivativesProvider();
        propagator.addAdditionalDerivativesProvider(derivativesProvider);
        return propagator;
    }

    private ODEIntegrator buildIntegrator(SpacecraftState initialState) {
        ODEIntegratorBuilder integratorBuilder = this.propagationSettings.getIntegrationSettings().getIntegratorBuilder();
        if (initialState.isOrbitDefined()) {
            Orbit orbit = initialState.getOrbit();
            return integratorBuilder.buildIntegrator(orbit, orbit.getType());
        }
        return integratorBuilder.buildIntegrator(initialState.getAbsPVA());
    }

    protected FieldNumericalPropagator<Gradient> buildFieldPropagator(FieldSpacecraftState<Gradient> initialState) {
        Field<Gradient> field = initialState.getDate().getField();
        FieldODEIntegrator<Gradient> integrator = this.buildFieldIntegrator(initialState);
        FieldNumericalPropagator<Gradient> propagator = new FieldNumericalPropagator<Gradient>(field, integrator, this.propagationSettings.getAttitudeProvider());
        propagator.setIgnoreCentralAttraction(true);
        propagator.removeForceModels();
        propagator.setInitialState(initialState);
        propagator.setIgnoreCentralAttraction(false);
        if (initialState.isOrbitDefined()) {
            propagator.setOrbitType(initialState.getOrbit().getType());
        } else {
            propagator.setOrbitType(null);
            if (this.propagationSettings.getForceModels().stream().noneMatch(NewtonianAttraction.class::isInstance)) {
                propagator.setIgnoreCentralAttraction(true);
            }
        }
        for (ForceModel forceModel : this.propagationSettings.getForceModels()) {
            propagator.addForceModel(forceModel);
        }
        FieldAdditionalDerivativesProvider<Gradient> derivativesProvider = this.propagationSettings.getAdjointDynamicsProvider().buildFieldAdditionalDerivativesProvider(field);
        propagator.addAdditionalDerivativesProvider(derivativesProvider);
        return propagator;
    }

    private <T extends CalculusFieldElement<T>> FieldODEIntegrator<T> buildFieldIntegrator(FieldSpacecraftState<T> initialState) {
        FieldODEIntegratorBuilder<T> integratorBuilder = this.propagationSettings.getIntegrationSettings().getFieldIntegratorBuilder(initialState.getMass().getField());
        if (initialState.isOrbitDefined()) {
            FieldOrbit<T> orbit = initialState.getOrbit();
            return integratorBuilder.buildIntegrator(orbit, orbit.getType());
        }
        return integratorBuilder.buildIntegrator(initialState.getAbsPVA());
    }
}

