/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.shooting;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.Attitude;
import org.orekit.control.indirect.adjoint.CartesianAdjointDerivativesProvider;
import org.orekit.control.indirect.adjoint.FieldCartesianAdjointDerivativesProvider;
import org.orekit.control.indirect.shooting.AbstractIndirectShooting;
import org.orekit.control.indirect.shooting.ShootingBoundaryOutput;
import org.orekit.control.indirect.shooting.boundary.CartesianBoundaryConditionChecker;
import org.orekit.control.indirect.shooting.boundary.FixedTimeBoundaryOrbits;
import org.orekit.control.indirect.shooting.boundary.FixedTimeCartesianBoundaryStates;
import org.orekit.control.indirect.shooting.propagation.ShootingPropagationSettings;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.FieldNumericalPropagator;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractFixedBoundaryCartesianSingleShooting
extends AbstractIndirectShooting {
    private static final double DEFAULT_SCALE = 1.0;
    private final SpacecraftState initialSpacecraftStateTemplate;
    private final TimeStampedPVCoordinates terminalCartesianState;
    private final CartesianBoundaryConditionChecker conditionChecker;
    private double scaleVelocityDefects;
    private double scalePositionDefects;
    private double toleranceMassAdjoint = 1.0E-10;

    protected AbstractFixedBoundaryCartesianSingleShooting(ShootingPropagationSettings propagationSettings, FixedTimeCartesianBoundaryStates boundaryConditions, CartesianBoundaryConditionChecker conditionChecker) {
        super(propagationSettings);
        this.conditionChecker = conditionChecker;
        this.initialSpacecraftStateTemplate = this.buildInitialStateTemplate(boundaryConditions.getInitialCartesianState());
        this.terminalCartesianState = boundaryConditions.getTerminalCartesianState().getPVCoordinates(propagationSettings.getPropagationFrame());
        this.scalePositionDefects = 1.0;
        this.scaleVelocityDefects = 1.0;
    }

    protected AbstractFixedBoundaryCartesianSingleShooting(ShootingPropagationSettings propagationSettings, FixedTimeBoundaryOrbits boundaryConditions, CartesianBoundaryConditionChecker conditionChecker) {
        super(propagationSettings);
        this.conditionChecker = conditionChecker;
        this.initialSpacecraftStateTemplate = this.buildInitialStateTemplate(boundaryConditions.getInitialOrbit());
        this.terminalCartesianState = boundaryConditions.getTerminalOrbit().getPVCoordinates(propagationSettings.getPropagationFrame());
        this.scalePositionDefects = 1.0;
        this.scaleVelocityDefects = 1.0;
    }

    public void setScalePositionDefects(double scalePositionDefects) {
        this.scalePositionDefects = scalePositionDefects;
    }

    public double getScalePositionDefects() {
        return this.scalePositionDefects;
    }

    public void setScaleVelocityDefects(double scaleVelocityDefects) {
        this.scaleVelocityDefects = scaleVelocityDefects;
    }

    public double getScaleVelocityDefects() {
        return this.scaleVelocityDefects;
    }

    protected CartesianBoundaryConditionChecker getConditionChecker() {
        return this.conditionChecker;
    }

    protected TimeStampedPVCoordinates getTerminalCartesianState() {
        return this.terminalCartesianState;
    }

    public void setToleranceMassAdjoint(double toleranceMassAdjoint) {
        this.toleranceMassAdjoint = FastMath.abs((double)toleranceMassAdjoint);
    }

    private SpacecraftState buildInitialStateTemplate(Orbit initialOrbit) {
        Frame frame = this.getPropagationSettings().getPropagationFrame();
        CartesianOrbit cartesianOrbit = new CartesianOrbit(initialOrbit.getPVCoordinates(frame), frame, initialOrbit.getDate(), initialOrbit.getMu());
        Attitude attitude = this.getPropagationSettings().getAttitudeProvider().getAttitude(cartesianOrbit, cartesianOrbit.getDate(), cartesianOrbit.getFrame());
        return new SpacecraftState((Orbit)cartesianOrbit, attitude);
    }

    private SpacecraftState buildInitialStateTemplate(AbsolutePVCoordinates initialCartesianState) {
        Frame frame = this.getPropagationSettings().getPropagationFrame();
        AbsolutePVCoordinates absolutePVCoordinates = new AbsolutePVCoordinates(frame, initialCartesianState.getPVCoordinates(frame));
        Attitude attitude = this.getPropagationSettings().getAttitudeProvider().getAttitude(absolutePVCoordinates, absolutePVCoordinates.getDate(), absolutePVCoordinates.getFrame());
        return new SpacecraftState(absolutePVCoordinates, attitude);
    }

    @Override
    public ShootingBoundaryOutput solve(double initialMass, double[] initialGuess) {
        SpacecraftState initialState = this.createStateWithMassAndAdjoint(initialMass, initialGuess);
        ShootingBoundaryOutput initialGuessSolution = this.computeCandidateSolution(initialState, 0);
        if (initialGuessSolution.isConverged()) {
            return initialGuessSolution;
        }
        return this.iterate(initialMass, initialGuess);
    }

    @Override
    protected NumericalPropagator buildPropagator(SpacecraftState initialState) {
        NumericalPropagator propagator = super.buildPropagator(initialState);
        CartesianAdjointDerivativesProvider derivativesProvider = (CartesianAdjointDerivativesProvider)this.getPropagationSettings().getAdjointDynamicsProvider().buildAdditionalDerivativesProvider();
        derivativesProvider.getCost().getEventDetectors().forEach(propagator::addEventDetector);
        return propagator;
    }

    @Override
    protected FieldNumericalPropagator<Gradient> buildFieldPropagator(FieldSpacecraftState<Gradient> initialState) {
        FieldNumericalPropagator<Gradient> fieldPropagator = super.buildFieldPropagator(initialState);
        Field field = fieldPropagator.getField();
        FieldCartesianAdjointDerivativesProvider derivativesProvider = (FieldCartesianAdjointDerivativesProvider)this.getPropagationSettings().getAdjointDynamicsProvider().buildFieldAdditionalDerivativesProvider(field);
        derivativesProvider.getCost().getFieldEventDetectors(field).forEach(fieldPropagator::addEventDetector);
        return fieldPropagator;
    }

    private ShootingBoundaryOutput computeCandidateSolution(SpacecraftState initialState, int iterationCount) {
        NumericalPropagator propagator = this.buildPropagator(initialState);
        SpacecraftState actualTerminalState = propagator.propagate(this.getTerminalCartesianState().getDate());
        boolean converged = this.checkConvergence(actualTerminalState);
        return new ShootingBoundaryOutput(converged, iterationCount, initialState, this.getPropagationSettings(), actualTerminalState);
    }

    private ShootingBoundaryOutput iterate(double initialMass, double[] initialGuess) {
        double[] initialAdjoint = (double[])initialGuess.clone();
        int maximumIterationCount = this.getConditionChecker().getMaximumIterationCount();
        SpacecraftState initialState = this.createStateWithMassAndAdjoint(initialMass, initialGuess);
        for (int iterationCount = 0; iterationCount < maximumIterationCount; ++iterationCount) {
            ShootingBoundaryOutput solution;
            FieldSpacecraftState<Gradient> fieldInitialState = this.createFieldStateWithMassAndAdjoint(initialMass, initialAdjoint);
            Field<Gradient> field = fieldInitialState.getDate().getField();
            FieldAbsoluteDate<Gradient> fieldTerminalDate = new FieldAbsoluteDate<Gradient>(field, this.getTerminalCartesianState().getDate());
            FieldNumericalPropagator<Gradient> fieldPropagator = this.buildFieldPropagator(fieldInitialState);
            FieldSpacecraftState<Gradient> fieldTerminalState = fieldPropagator.propagate(fieldTerminalDate);
            initialState = fieldInitialState.toSpacecraftState();
            if (this.checkConvergence(fieldTerminalState.toSpacecraftState()) && (solution = this.computeCandidateSolution(initialState, iterationCount)).isConverged()) {
                return solution;
            }
            if (Double.isNaN((initialAdjoint = this.updateAdjoint(initialAdjoint, fieldTerminalState))[0])) {
                return this.computeCandidateSolution(initialState, iterationCount);
            }
            maximumIterationCount = this.getConditionChecker().getMaximumIterationCount();
        }
        return this.computeCandidateSolution(initialState, maximumIterationCount);
    }

    private boolean checkConvergence(SpacecraftState actualTerminalState) {
        boolean isCartesianConverged = this.getConditionChecker().isConverged(this.getTerminalCartesianState(), actualTerminalState.getPVCoordinates());
        if (isCartesianConverged) {
            String adjointName = this.getPropagationSettings().getAdjointDynamicsProvider().getAdjointName();
            double[] terminalAdjoint = actualTerminalState.getAdditionalState(adjointName);
            if (terminalAdjoint.length == 7) {
                return FastMath.abs((double)terminalAdjoint[6]) < this.toleranceMassAdjoint;
            }
            return true;
        }
        return false;
    }

    protected SpacecraftState createStateWithMassAndAdjoint(double initialMass, double[] initialAdjoint) {
        String adjointName = this.getPropagationSettings().getAdjointDynamicsProvider().getAdjointName();
        return this.createStateWithMass(initialMass).addAdditionalState(adjointName, initialAdjoint);
    }

    private SpacecraftState createStateWithMass(double initialMass) {
        if (this.initialSpacecraftStateTemplate.isOrbitDefined()) {
            return new SpacecraftState(this.initialSpacecraftStateTemplate.getOrbit(), this.initialSpacecraftStateTemplate.getAttitude(), initialMass);
        }
        return new SpacecraftState(this.initialSpacecraftStateTemplate.getAbsPVA(), this.initialSpacecraftStateTemplate.getAttitude(), initialMass);
    }

    protected FieldSpacecraftState<Gradient> createFieldStateWithMassAndAdjoint(double initialMass, double[] initialAdjoint) {
        int parametersNumber = initialAdjoint.length;
        GradientField field = GradientField.getField((int)parametersNumber);
        FieldSpacecraftState stateWithoutAdjoint = new FieldSpacecraftState(field, this.createStateWithMass(initialMass));
        Gradient[] fieldInitialAdjoint = (Gradient[])MathArrays.buildArray((Field)field, (int)initialAdjoint.length);
        for (int i = 0; i < parametersNumber; ++i) {
            fieldInitialAdjoint[i] = Gradient.variable((int)parametersNumber, (int)i, (double)initialAdjoint[i]);
        }
        String adjointName = this.getPropagationSettings().getAdjointDynamicsProvider().getAdjointName();
        return stateWithoutAdjoint.addAdditionalState(adjointName, (CalculusFieldElement[])fieldInitialAdjoint);
    }

    protected abstract double[] updateAdjoint(double[] var1, FieldSpacecraftState<Gradient> var2);
}

