/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint.cost;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.control.indirect.adjoint.cost.AbstractCartesianEnergy;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;

public class UnboundedCartesianEnergyNeglectingMass
extends AbstractCartesianEnergy {
    public UnboundedCartesianEnergyNeglectingMass(String name) {
        super(name, 0.0);
    }

    @Override
    public int getAdjointDimension() {
        return 6;
    }

    @Override
    public double getMassFlowRateFactor() {
        return 0.0;
    }

    @Override
    public Vector3D getThrustAccelerationVector(double[] adjointVariables, double mass) {
        return new Vector3D(adjointVariables[3], adjointVariables[4], adjointVariables[5]);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldThrustAccelerationVector(T[] adjointVariables, T mass) {
        return new FieldVector3D(adjointVariables[3], adjointVariables[4], adjointVariables[5]);
    }

    @Override
    public void updateAdjointDerivatives(double[] adjointVariables, double mass, double[] adjointDerivatives) {
    }

    @Override
    public <T extends CalculusFieldElement<T>> void updateFieldAdjointDerivatives(T[] adjointVariables, T mass, T[] adjointDerivatives) {
    }

    @Override
    public double getHamiltonianContribution(double[] adjointVariables, double mass) {
        Vector3D thrustAcceleration = this.getThrustAccelerationVector(adjointVariables, mass);
        return -thrustAcceleration.getNormSq() / 2.0;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFieldHamiltonianContribution(T[] adjointVariables, T mass) {
        FieldVector3D thrustAcceleration = this.getFieldThrustAccelerationVector((CalculusFieldElement[])adjointVariables, (CalculusFieldElement)mass);
        return (T)((CalculusFieldElement)thrustAcceleration.getNormSq().multiply(-0.5));
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return Stream.empty();
    }
}

