/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint.cost;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.control.indirect.adjoint.cost.CartesianEnergyConsideringMass;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;

public class UnboundedCartesianEnergy
extends CartesianEnergyConsideringMass {
    public UnboundedCartesianEnergy(String name, double massFlowRateFactor, EventDetectionSettings eventDetectionSettings) {
        super(name, massFlowRateFactor, eventDetectionSettings);
    }

    public UnboundedCartesianEnergy(String name, double massFlowRateFactor) {
        this(name, massFlowRateFactor, EventDetectionSettings.getDefaultEventDetectionSettings());
    }

    @Override
    protected double getThrustForceNorm(double[] adjointVariables, double mass) {
        double adjointVelocityNorm = this.getAdjointVelocityNorm(adjointVariables);
        double factor = adjointVelocityNorm / mass - this.getMassFlowRateFactor() * adjointVariables[6];
        return FastMath.max((double)0.0, (double)factor);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T getFieldThrustForceNorm(T[] adjointVariables, T mass) {
        CalculusFieldElement adjointVelocityNorm = this.getFieldAdjointVelocityNorm((CalculusFieldElement[])adjointVariables);
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)adjointVelocityNorm.divide(mass)).subtract((FieldElement)((CalculusFieldElement)adjointVariables[6].multiply(this.getMassFlowRateFactor())));
        if (factor.getReal() < 0.0) {
            return (T)((CalculusFieldElement)adjointVelocityNorm.getField().getZero());
        }
        return (T)factor;
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        return Stream.of(new CartesianEnergyConsideringMass.SingularityDetector(this, this.getEventDetectionSettings(), new ResetDerivativesOnEvent(), 0.0));
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return Stream.of(new CartesianEnergyConsideringMass.FieldSingularityDetector((CartesianEnergyConsideringMass)this, new FieldEventDetectionSettings<T>(field, this.getEventDetectionSettings()), new FieldResetDerivativesOnEvent(), (CalculusFieldElement)field.getZero()));
    }
}

