/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint.cost;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.control.indirect.adjoint.cost.AbstractCartesianEnergy;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;

abstract class CartesianEnergyConsideringMass
extends AbstractCartesianEnergy {
    private final EventDetectionSettings eventDetectionSettings;

    protected CartesianEnergyConsideringMass(String name, double massFlowRateFactor, EventDetectionSettings eventDetectionSettings) {
        super(name, massFlowRateFactor);
        this.eventDetectionSettings = eventDetectionSettings;
    }

    public EventDetectionSettings getEventDetectionSettings() {
        return this.eventDetectionSettings;
    }

    @Override
    public Vector3D getThrustAccelerationVector(double[] adjointVariables, double mass) {
        return this.getThrustDirection(adjointVariables).scalarMultiply(this.getThrustForceNorm(adjointVariables, mass) / mass);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldThrustAccelerationVector(T[] adjointVariables, T mass) {
        return this.getFieldThrustDirection((CalculusFieldElement[])adjointVariables).scalarMultiply((CalculusFieldElement)this.getFieldThrustForceNorm((CalculusFieldElement[])adjointVariables, (CalculusFieldElement)mass).divide(mass));
    }

    protected Vector3D getThrustDirection(double[] adjointVariables) {
        return (Vector3D)new Vector3D(adjointVariables[3], adjointVariables[4], adjointVariables[5]).normalize();
    }

    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldThrustDirection(T[] adjointVariables) {
        return new FieldVector3D(adjointVariables[3], adjointVariables[4], adjointVariables[5]).normalize();
    }

    protected abstract double getThrustForceNorm(double[] var1, double var2);

    protected abstract <T extends CalculusFieldElement<T>> T getFieldThrustForceNorm(T[] var1, T var2);

    @Override
    public void updateAdjointDerivatives(double[] adjointVariables, double mass, double[] adjointDerivatives) {
        adjointDerivatives[6] = adjointDerivatives[6] + this.getThrustForceNorm(adjointVariables, mass) * this.getAdjointVelocityNorm(adjointVariables) / (mass * mass);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void updateFieldAdjointDerivatives(T[] adjointVariables, T mass, T[] adjointDerivatives) {
        adjointDerivatives[6] = (CalculusFieldElement)adjointDerivatives[6].add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getFieldThrustForceNorm((CalculusFieldElement[])adjointVariables, (CalculusFieldElement)mass).multiply((FieldElement)this.getFieldAdjointVelocityNorm((CalculusFieldElement[])adjointVariables))).divide((FieldElement)((CalculusFieldElement)mass.square()))));
    }

    @Override
    public double getHamiltonianContribution(double[] adjointVariables, double mass) {
        Vector3D thrustForce = this.getThrustAccelerationVector(adjointVariables, mass).scalarMultiply(mass);
        return -thrustForce.getNormSq() / 2.0;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFieldHamiltonianContribution(T[] adjointVariables, T mass) {
        FieldVector3D thrustForce = this.getFieldThrustAccelerationVector((CalculusFieldElement[])adjointVariables, (CalculusFieldElement)mass).scalarMultiply(mass);
        return (T)((CalculusFieldElement)thrustForce.getNormSq().multiply(-0.5));
    }

    static class FieldSingularityDetector<T extends CalculusFieldElement<T>>
    extends FieldAbstractDetector<FieldSingularityDetector<T>, T> {
        private final T detectionValue;
        final /* synthetic */ CartesianEnergyConsideringMass this$0;

        protected FieldSingularityDetector(FieldEventDetectionSettings<T> eventDetectionSettings, FieldEventHandler<T> handler, T detectionValue) {
            this.this$0 = this$0;
            super(eventDetectionSettings, handler);
            this.detectionValue = detectionValue;
        }

        @Override
        public T g(FieldSpacecraftState<T> state) {
            CalculusFieldElement[] adjoint = state.getAdditionalState(this.this$0.getAdjointName());
            return (T)((CalculusFieldElement)this.evaluateVariablePart(adjoint, (CalculusFieldElement)state.getMass()).subtract(this.detectionValue));
        }

        private T evaluateVariablePart(T[] adjointVariables, T mass) {
            CalculusFieldElement adjointVelocityNorm = this.this$0.getFieldAdjointVelocityNorm((CalculusFieldElement[])adjointVariables);
            return (T)((CalculusFieldElement)((CalculusFieldElement)adjointVelocityNorm.divide(mass)).subtract((FieldElement)((CalculusFieldElement)adjointVariables[6].multiply(this.this$0.getMassFlowRateFactor()))));
        }

        @Override
        protected FieldSingularityDetector<T> create(FieldAdaptableInterval<T> newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<T> newHandler) {
            return new FieldSingularityDetector(this.this$0, new FieldEventDetectionSettings<T>(newMaxCheck, newThreshold, newMaxIter), newHandler, this.detectionValue);
        }
    }

    class SingularityDetector
    extends AbstractDetector<SingularityDetector> {
        private final double detectionValue;

        SingularityDetector(EventDetectionSettings eventDetectionSettings, EventHandler handler, double detectionValue) {
            super(eventDetectionSettings, handler);
            this.detectionValue = detectionValue;
        }

        @Override
        public double g(SpacecraftState state) {
            double[] adjoint = state.getAdditionalState(CartesianEnergyConsideringMass.this.getAdjointName());
            return this.evaluateVariablePart(adjoint, state.getMass()) - this.detectionValue;
        }

        private double evaluateVariablePart(double[] adjointVariables, double mass) {
            double adjointVelocityNorm = CartesianEnergyConsideringMass.this.getAdjointVelocityNorm(adjointVariables);
            return adjointVelocityNorm / mass - CartesianEnergyConsideringMass.this.getMassFlowRateFactor() * adjointVariables[6];
        }

        @Override
        protected SingularityDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
            return new SingularityDetector(new EventDetectionSettings(newMaxCheck, newThreshold, newMaxIter), newHandler, this.detectionValue);
        }
    }
}

