/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint.cost;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.control.indirect.adjoint.cost.CartesianEnergyConsideringMass;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetectionSettings;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldResetDerivativesOnEvent;
import org.orekit.propagation.events.handlers.ResetDerivativesOnEvent;

public class BoundedCartesianEnergy
extends CartesianEnergyConsideringMass {
    private final double maximumThrustMagnitude;

    public BoundedCartesianEnergy(String name, double massFlowRateFactor, double maximumThrustMagnitude, EventDetectionSettings eventDetectionSettings) {
        super(name, massFlowRateFactor, eventDetectionSettings);
        this.maximumThrustMagnitude = FastMath.abs((double)maximumThrustMagnitude);
    }

    public BoundedCartesianEnergy(String name, double massFlowRateFactor, double maximumThrustMagnitude) {
        this(name, massFlowRateFactor, maximumThrustMagnitude, EventDetectionSettings.getDefaultEventDetectionSettings());
    }

    @Override
    protected double getThrustForceNorm(double[] adjointVariables, double mass) {
        double adjointVelocityNorm = this.getAdjointVelocityNorm(adjointVariables);
        double factor = adjointVelocityNorm / mass - this.getMassFlowRateFactor() * adjointVariables[6];
        if (factor > this.maximumThrustMagnitude) {
            return this.maximumThrustMagnitude;
        }
        return FastMath.max((double)0.0, (double)factor);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T getFieldThrustForceNorm(T[] adjointVariables, T mass) {
        CalculusFieldElement adjointVelocityNorm = this.getFieldAdjointVelocityNorm((CalculusFieldElement[])adjointVariables);
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)adjointVelocityNorm.divide(mass)).subtract((FieldElement)((CalculusFieldElement)adjointVariables[6].multiply(this.getMassFlowRateFactor())));
        double factorReal = factor.getReal();
        CalculusFieldElement zero = (CalculusFieldElement)mass.getField().getZero();
        if (factorReal > this.maximumThrustMagnitude) {
            return (T)((CalculusFieldElement)zero.newInstance(this.maximumThrustMagnitude));
        }
        if (factorReal < 0.0) {
            return (T)zero;
        }
        return (T)factor;
    }

    @Override
    public Stream<EventDetector> getEventDetectors() {
        EventDetectionSettings detectionSettings = this.getEventDetectionSettings();
        return Stream.of(new CartesianEnergyConsideringMass.SingularityDetector(this, detectionSettings, new ResetDerivativesOnEvent(), 0.0), new CartesianEnergyConsideringMass.SingularityDetector(this, detectionSettings, new ResetDerivativesOnEvent(), this.maximumThrustMagnitude));
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        FieldEventDetectionSettings<T> detectionSettings = new FieldEventDetectionSettings<T>(field, this.getEventDetectionSettings());
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement maximumThrustMagnitudeForEvent = (CalculusFieldElement)zero.newInstance(this.maximumThrustMagnitude);
        return Stream.of(new CartesianEnergyConsideringMass.FieldSingularityDetector((CartesianEnergyConsideringMass)this, detectionSettings, new FieldResetDerivativesOnEvent(), zero), new CartesianEnergyConsideringMass.FieldSingularityDetector((CartesianEnergyConsideringMass)this, detectionSettings, new FieldResetDerivativesOnEvent(), maximumThrustMagnitudeForEvent));
    }
}

