/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint.cost;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.control.indirect.adjoint.cost.CartesianCost;

public abstract class AbstractCartesianEnergy
implements CartesianCost {
    private final String name;
    private final double massFlowRateFactor;

    protected AbstractCartesianEnergy(String name, double massFlowRateFactor) {
        this.name = name;
        this.massFlowRateFactor = FastMath.abs((double)massFlowRateFactor);
    }

    @Override
    public String getAdjointName() {
        return this.name;
    }

    @Override
    public double getMassFlowRateFactor() {
        return this.massFlowRateFactor;
    }

    protected double getAdjointVelocityNorm(double[] adjointVariables) {
        return FastMath.sqrt((double)(adjointVariables[3] * adjointVariables[3] + adjointVariables[4] * adjointVariables[4] + adjointVariables[5] * adjointVariables[5]));
    }

    protected <T extends CalculusFieldElement<T>> T getFieldAdjointVelocityNorm(T[] adjointVariables) {
        return (T)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)adjointVariables[3].square()).add((FieldElement)((CalculusFieldElement)adjointVariables[4].square()))).add((FieldElement)((CalculusFieldElement)adjointVariables[5].square()))));
    }
}

