/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointDerivativesProvider;
import org.orekit.control.indirect.adjoint.CartesianAdjointEquationTerm;
import org.orekit.control.indirect.adjoint.cost.CartesianCost;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.integration.FieldAdditionalDerivativesProvider;
import org.orekit.propagation.integration.FieldCombinedDerivatives;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCartesianAdjointDerivativesProvider<T extends CalculusFieldElement<T>>
extends AbstractCartesianAdjointDerivativesProvider
implements FieldAdditionalDerivativesProvider<T> {
    private final CartesianAdjointEquationTerm[] adjointEquationTerms;

    public FieldCartesianAdjointDerivativesProvider(CartesianCost cost, CartesianAdjointEquationTerm ... adjointEquationTerms) {
        super(cost);
        this.adjointEquationTerms = adjointEquationTerms;
    }

    @Override
    public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        FieldAdditionalDerivativesProvider.super.init(initialState, target);
        if (initialState.isOrbitDefined() && initialState.getOrbit().getType() != OrbitType.CARTESIAN) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_COORDINATES_FOR_ADJOINT_EQUATION, new Object[0]);
        }
    }

    @Override
    public FieldCombinedDerivatives<T> combinedDerivatives(FieldSpacecraftState<T> state) {
        T mass = state.getMass();
        CalculusFieldElement[] adjointVariables = state.getAdditionalState(this.getName());
        int adjointDimension = this.getDimension();
        CalculusFieldElement[] additionalDerivatives = (CalculusFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)adjointDimension);
        CalculusFieldElement[] cartesianVariablesAndMass = this.formCartesianAndMassVector(state);
        CalculusFieldElement[] mainDerivativesIncrements = (CalculusFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)7);
        FieldVector3D thrustAccelerationVector = this.getCost().getFieldThrustAccelerationVector(adjointVariables, (CalculusFieldElement)mass);
        mainDerivativesIncrements[3] = thrustAccelerationVector.getX();
        mainDerivativesIncrements[4] = thrustAccelerationVector.getY();
        mainDerivativesIncrements[5] = thrustAccelerationVector.getZ();
        CalculusFieldElement thrustAccelerationNorm = thrustAccelerationVector.getNorm();
        if (thrustAccelerationVector.getNorm().getReal() != 0.0) {
            CalculusFieldElement thrustForceMagnitude = (CalculusFieldElement)thrustAccelerationNorm.multiply(mass);
            mainDerivativesIncrements[6] = (CalculusFieldElement)thrustForceMagnitude.multiply(-this.getCost().getMassFlowRateFactor());
        }
        additionalDerivatives[3] = (CalculusFieldElement)adjointVariables[0].negate();
        additionalDerivatives[4] = (CalculusFieldElement)adjointVariables[1].negate();
        additionalDerivatives[5] = (CalculusFieldElement)adjointVariables[2].negate();
        FieldAbsoluteDate<T> date = state.getDate();
        Frame propagationFrame = state.getFrame();
        for (CartesianAdjointEquationTerm equationTerm : this.adjointEquationTerms) {
            CalculusFieldElement[] contribution = equationTerm.getFieldRatesContribution(date, cartesianVariablesAndMass, adjointVariables, propagationFrame);
            for (int i = 0; i < FastMath.min((int)adjointDimension, (int)contribution.length); ++i) {
                additionalDerivatives[i] = (CalculusFieldElement)additionalDerivatives[i].add((FieldElement)contribution[i]);
            }
        }
        this.getCost().updateFieldAdjointDerivatives(adjointVariables, (CalculusFieldElement)mass, additionalDerivatives);
        return new FieldCombinedDerivatives(additionalDerivatives, mainDerivativesIncrements);
    }

    private T[] formCartesianAndMassVector(FieldSpacecraftState<T> state) {
        T mass = state.getMass();
        CalculusFieldElement[] cartesianVariablesAndMass = (CalculusFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)7);
        TimeStampedFieldPVCoordinates<T> pvCoordinates = state.getPVCoordinates();
        System.arraycopy(pvCoordinates.getPosition().toArray(), 0, cartesianVariablesAndMass, 0, 3);
        System.arraycopy(pvCoordinates.getVelocity().toArray(), 0, cartesianVariablesAndMass, 3, 3);
        cartesianVariablesAndMass[6] = mass;
        return cartesianVariablesAndMass;
    }

    public T evaluateHamiltonian(FieldSpacecraftState<T> state) {
        CalculusFieldElement[] cartesianAndMassVector = this.formCartesianAndMassVector(state);
        CalculusFieldElement[] adjointVariables = state.getAdditionalState(this.getName());
        CalculusFieldElement hamiltonian = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)adjointVariables[0].multiply((FieldElement)cartesianAndMassVector[3])).add((FieldElement)((CalculusFieldElement)adjointVariables[1].multiply((FieldElement)cartesianAndMassVector[4])))).add((FieldElement)((CalculusFieldElement)adjointVariables[2].multiply((FieldElement)cartesianAndMassVector[5])));
        FieldAbsoluteDate<T> date = state.getDate();
        Frame propagationFrame = state.getFrame();
        for (CartesianAdjointEquationTerm adjointEquationTerm : this.adjointEquationTerms) {
            CalculusFieldElement contribution = adjointEquationTerm.getFieldHamiltonianContribution(date, cartesianAndMassVector, adjointVariables, propagationFrame);
            hamiltonian = (CalculusFieldElement)hamiltonian.add((FieldElement)contribution);
        }
        if (adjointVariables.length != 6) {
            T mass = state.getMass();
            CalculusFieldElement thrustAccelerationNorm = this.getCost().getFieldThrustAccelerationVector(adjointVariables, (CalculusFieldElement)mass).getNorm();
            CalculusFieldElement thrustForceNorm = (CalculusFieldElement)thrustAccelerationNorm.multiply(mass);
            hamiltonian = (CalculusFieldElement)hamiltonian.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)adjointVariables[6].multiply(this.getCost().getMassFlowRateFactor())).multiply((FieldElement)thrustForceNorm)));
        }
        hamiltonian = (CalculusFieldElement)hamiltonian.add((FieldElement)this.getCost().getFieldHamiltonianContribution(adjointVariables, (CalculusFieldElement)state.getMass()));
        return (T)hamiltonian;
    }
}

