/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointNonCentralBodyTerm;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPositionProvider;

public class CartesianAdjointThirdBodyTerm
extends AbstractCartesianAdjointNonCentralBodyTerm {
    public CartesianAdjointThirdBodyTerm(double mu, ExtendedPositionProvider bodyPositionProvider) {
        super(mu, bodyPositionProvider);
    }

    @Override
    public Vector3D getAcceleration(AbsoluteDate date, double[] stateVariables, Frame frame) {
        Vector3D bodyPosition = this.getBodyPosition(date, frame);
        double x = stateVariables[0] - bodyPosition.getX();
        double y = stateVariables[1] - bodyPosition.getY();
        double z = stateVariables[2] - bodyPosition.getZ();
        Vector3D newtonianAcceleration = this.getNewtonianAcceleration(new double[]{x, y, z});
        double rBody2 = bodyPosition.getNormSq();
        Vector3D bodyCentralAcceleration = bodyPosition.scalarMultiply(this.getMu() / (rBody2 * FastMath.sqrt((double)rBody2)));
        return newtonianAcceleration.subtract((Vector)bodyCentralAcceleration);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldAcceleration(FieldAbsoluteDate<T> date, T[] stateVariables, Frame frame) {
        FieldVector3D<T> bodyPosition = this.getFieldBodyPosition(date, frame);
        CalculusFieldElement x = (CalculusFieldElement)stateVariables[0].subtract((FieldElement)bodyPosition.getX());
        CalculusFieldElement y = (CalculusFieldElement)stateVariables[1].subtract((FieldElement)bodyPosition.getY());
        CalculusFieldElement z = (CalculusFieldElement)stateVariables[2].subtract((FieldElement)bodyPosition.getZ());
        CalculusFieldElement[] relativePosition = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
        relativePosition[0] = x;
        relativePosition[1] = y;
        relativePosition[2] = z;
        FieldVector3D newtonianAcceleration = this.getFieldNewtonianAcceleration(relativePosition);
        CalculusFieldElement rBody2 = bodyPosition.getNormSq();
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rBody2.multiply((FieldElement)((CalculusFieldElement)rBody2.sqrt()))).reciprocal()).multiply(this.getMu());
        FieldVector3D bodyCentralAcceleration = bodyPosition.scalarMultiply(factor);
        return newtonianAcceleration.subtract(bodyCentralAcceleration);
    }
}

