/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.analysis.differentiation.FieldGradientField;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointGravitationalTerm;
import org.orekit.forces.gravity.J2OnlyPerturbation;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;

public class CartesianAdjointJ2Term
extends AbstractCartesianAdjointGravitationalTerm {
    private final double j2;
    private final double rEq;
    private final Frame j2Frame;

    public CartesianAdjointJ2Term(double mu, double rEq, double j2, Frame j2Frame) {
        super(mu);
        this.j2 = j2;
        this.rEq = rEq;
        this.j2Frame = j2Frame;
    }

    public double getrEq() {
        return this.rEq;
    }

    public double getJ2() {
        return this.j2;
    }

    @Override
    public double[] getPositionAdjointContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        double[] contribution = new double[3];
        int numberOfGradientVariables = 3;
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)3, (int)0, (double)stateVariables[0]), (CalculusFieldElement)Gradient.variable((int)3, (int)1, (double)stateVariables[1]), (CalculusFieldElement)Gradient.variable((int)3, (int)2, (double)stateVariables[2]));
        StaticTransform transform = frame.getStaticTransformTo(this.j2Frame, date);
        FieldVector3D positionInJ2Frame = transform.transformPosition(position);
        Gradient fieldJ2 = Gradient.constant((int)3, (double)this.j2);
        FieldVector3D<Gradient> accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.getMu(), this.rEq, fieldJ2);
        FieldVector3D<Gradient> acceleration = transform.getStaticInverse().transformVector(accelerationInJ2Frame);
        double pvx = adjointVariables[3];
        double pvy = adjointVariables[4];
        double pvz = adjointVariables[5];
        double[] gradientAccelerationX = ((Gradient)acceleration.getX()).getGradient();
        double[] gradientAccelerationY = ((Gradient)acceleration.getY()).getGradient();
        double[] gradientAccelerationZ = ((Gradient)acceleration.getZ()).getGradient();
        contribution[0] = -(gradientAccelerationX[0] * pvx + gradientAccelerationY[0] * pvy + gradientAccelerationZ[0] * pvz);
        contribution[1] = -(gradientAccelerationX[1] * pvx + gradientAccelerationY[1] * pvy + gradientAccelerationZ[1] * pvz);
        contribution[2] = -(gradientAccelerationX[2] * pvx + gradientAccelerationY[2] * pvy + gradientAccelerationZ[2] * pvz);
        return contribution;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] getPositionAdjointFieldContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        Field field = adjointVariables[0].getField();
        CalculusFieldElement[] contribution = (CalculusFieldElement[])MathArrays.buildArray((Field)field, (int)3);
        int numberOfGradientVariables = 3;
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)FieldGradient.variable((int)3, (int)0, stateVariables[0]), (CalculusFieldElement)FieldGradient.variable((int)3, (int)1, stateVariables[1]), (CalculusFieldElement)FieldGradient.variable((int)3, (int)2, stateVariables[2]));
        T shift = date.durationFrom(date.toAbsoluteDate());
        FieldGradientField gradientField = FieldGradientField.getField((Field)field, (int)3);
        FieldTimeShiftable gradientDate = new FieldAbsoluteDate(gradientField, date.toAbsoluteDate()).shiftedBy((CalculusFieldElement)FieldGradient.constant((int)3, shift));
        FieldStaticTransform transform = frame.getStaticTransformTo(this.j2Frame, gradientDate);
        FieldVector3D positionInJ2Frame = transform.transformPosition(position);
        FieldGradient fieldJ2 = FieldGradient.constant((int)3, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(this.j2)));
        FieldVector3D<FieldGradient> accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.getMu(), this.rEq, fieldJ2);
        FieldVector3D<FieldGradient> acceleration = transform.getStaticInverse().transformVector(accelerationInJ2Frame);
        T pvx = adjointVariables[3];
        T pvy = adjointVariables[4];
        T pvz = adjointVariables[5];
        CalculusFieldElement[] gradientAccelerationX = ((FieldGradient)acceleration.getX()).getGradient();
        CalculusFieldElement[] gradientAccelerationY = ((FieldGradient)acceleration.getY()).getGradient();
        CalculusFieldElement[] gradientAccelerationZ = ((FieldGradient)acceleration.getZ()).getGradient();
        contribution[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradientAccelerationX[0].multiply(pvx)).add((FieldElement)((CalculusFieldElement)gradientAccelerationY[0].multiply(pvy)))).add((FieldElement)((CalculusFieldElement)gradientAccelerationZ[0].multiply(pvz)));
        contribution[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradientAccelerationX[1].multiply(pvx)).add((FieldElement)((CalculusFieldElement)gradientAccelerationY[1].multiply(pvy)))).add((FieldElement)((CalculusFieldElement)gradientAccelerationZ[1].multiply(pvz)));
        contribution[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gradientAccelerationX[2].multiply(pvx)).add((FieldElement)((CalculusFieldElement)gradientAccelerationY[2].multiply(pvy)))).add((FieldElement)((CalculusFieldElement)gradientAccelerationZ[2].multiply(pvz)));
        contribution[0] = (CalculusFieldElement)contribution[0].negate();
        contribution[1] = (CalculusFieldElement)contribution[1].negate();
        contribution[2] = (CalculusFieldElement)contribution[2].negate();
        return contribution;
    }

    @Override
    public Vector3D getAcceleration(AbsoluteDate date, double[] stateVariables, Frame frame) {
        StaticTransform transform = frame.getStaticTransformTo(this.j2Frame, date);
        Vector3D positionInJ2Frame = transform.transformPosition(new Vector3D(stateVariables[0], stateVariables[1], stateVariables[2]));
        Vector3D accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.getMu(), this.rEq, this.getJ2());
        return transform.getStaticInverse().transformVector(accelerationInJ2Frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldAcceleration(FieldAbsoluteDate<T> date, T[] stateVariables, Frame frame) {
        FieldStaticTransform<T> transform = frame.getStaticTransformTo(this.j2Frame, date);
        FieldVector3D<T> positionInJ2Frame = transform.transformPosition(new FieldVector3D(stateVariables[0], stateVariables[1], stateVariables[2]));
        FieldVector3D<CalculusFieldElement> accelerationInJ2Frame = J2OnlyPerturbation.computeAccelerationInJ2Frame(positionInJ2Frame, this.getMu(), this.rEq, (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(this.getJ2()));
        return transform.getStaticInverse().transformVector(accelerationInJ2Frame);
    }
}

