/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointEquationTerm;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class CartesianAdjointInertialTerm
extends AbstractCartesianAdjointEquationTerm {
    private final Frame referenceInertialFrame;

    public CartesianAdjointInertialTerm(Frame referenceInertialFrame) {
        this.referenceInertialFrame = referenceInertialFrame;
        if (!referenceInertialFrame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME_NOT_SUITABLE_AS_REFERENCE_FOR_INERTIAL_FORCES, referenceInertialFrame.getName());
        }
    }

    public Frame getReferenceInertialFrame() {
        return this.referenceInertialFrame;
    }

    @Override
    public double[] getRatesContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        double[] contribution = new double[adjointVariables.length];
        Gradient[] gradients = CartesianAdjointInertialTerm.buildGradientCartesianVector(stateVariables);
        Transform transform = this.getReferenceInertialFrame().getTransformTo(frame, date);
        FieldTransform fieldTransform = new FieldTransform(gradients[0].getField(), transform);
        FieldVector3D acceleration = this.getFieldAcceleration(fieldTransform, (CalculusFieldElement[])gradients);
        double[] accelerationXgradient = ((Gradient)acceleration.getX()).getGradient();
        double[] accelerationYgradient = ((Gradient)acceleration.getY()).getGradient();
        double[] accelerationZgradient = ((Gradient)acceleration.getZ()).getGradient();
        for (int i = 0; i < 6; ++i) {
            contribution[i] = -(accelerationXgradient[i] * adjointVariables[3] + accelerationYgradient[i] * adjointVariables[4] + accelerationZgradient[i] * adjointVariables[5]);
        }
        return contribution;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] getFieldRatesContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        CalculusFieldElement[] contribution = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)6);
        FieldGradient[] gradients = CartesianAdjointInertialTerm.buildFieldGradientCartesianVector(stateVariables);
        FieldTransform<T> transform = this.getReferenceInertialFrame().getTransformTo(frame, date);
        FieldTransform fieldTransform = new FieldTransform(gradients[0].getField(), new Transform(date.toAbsoluteDate(), transform.getAngular().toAngularCoordinates()));
        FieldVector3D acceleration = this.getFieldAcceleration(fieldTransform, (CalculusFieldElement[])gradients);
        CalculusFieldElement[] accelerationXgradient = ((FieldGradient)acceleration.getX()).getGradient();
        CalculusFieldElement[] accelerationYgradient = ((FieldGradient)acceleration.getY()).getGradient();
        CalculusFieldElement[] accelerationZgradient = ((FieldGradient)acceleration.getZ()).getGradient();
        for (int i = 0; i < 6; ++i) {
            contribution[i] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)accelerationXgradient[i].multiply(adjointVariables[3])).add((FieldElement)((CalculusFieldElement)accelerationYgradient[i].multiply(adjointVariables[4])))).add((FieldElement)((CalculusFieldElement)accelerationZgradient[i].multiply(adjointVariables[5])))).negate();
        }
        return contribution;
    }

    @Override
    protected Vector3D getAcceleration(AbsoluteDate date, double[] stateVariables, Frame frame) {
        Transform transform = this.getReferenceInertialFrame().getTransformTo(frame, date);
        return this.getAcceleration(transform, stateVariables);
    }

    public Vector3D getAcceleration(Transform inertialToPropagationFrame, double[] stateVariables) {
        Vector3D a1 = inertialToPropagationFrame.getCartesian().getAcceleration();
        Rotation r1 = inertialToPropagationFrame.getAngular().getRotation();
        Vector3D o1 = inertialToPropagationFrame.getAngular().getRotationRate();
        Vector3D oDot1 = inertialToPropagationFrame.getAngular().getRotationAcceleration();
        Vector3D p2 = new Vector3D(stateVariables[0], stateVariables[1], stateVariables[2]);
        Vector3D v2 = new Vector3D(stateVariables[3], stateVariables[4], stateVariables[5]);
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)o1, (Vector3D)Vector3D.crossProduct((Vector3D)o1, (Vector3D)p2));
        Vector3D crossV = Vector3D.crossProduct((Vector3D)o1, (Vector3D)v2);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)oDot1, (Vector3D)p2);
        return r1.applyTo(a1).subtract((Vector)new Vector3D(2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP));
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldAcceleration(FieldAbsoluteDate<T> date, T[] stateVariables, Frame frame) {
        FieldTransform<T> transform = this.getReferenceInertialFrame().getTransformTo(frame, date);
        return this.getFieldAcceleration(transform, (CalculusFieldElement[])stateVariables);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldAcceleration(FieldTransform<T> inertialToPropagationFrame, T[] stateVariables) {
        FieldVector3D<T> a1 = inertialToPropagationFrame.getCartesian().getAcceleration();
        FieldRotation<T> r1 = inertialToPropagationFrame.getAngular().getRotation();
        FieldVector3D<T> o1 = inertialToPropagationFrame.getAngular().getRotationRate();
        FieldVector3D<T> oDot1 = inertialToPropagationFrame.getAngular().getRotationAcceleration();
        FieldVector3D p2 = new FieldVector3D(stateVariables[0], stateVariables[1], stateVariables[2]);
        FieldVector3D v2 = new FieldVector3D(stateVariables[3], stateVariables[4], stateVariables[5]);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(o1, (FieldVector3D)FieldVector3D.crossProduct(o1, (FieldVector3D)p2));
        FieldVector3D crossV = FieldVector3D.crossProduct(o1, (FieldVector3D)v2);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(oDot1, (FieldVector3D)p2);
        return r1.applyTo(a1).subtract(new FieldVector3D(2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP));
    }
}

