/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointDerivativesProvider;
import org.orekit.control.indirect.adjoint.CartesianAdjointEquationTerm;
import org.orekit.control.indirect.adjoint.cost.CartesianCost;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CartesianAdjointDerivativesProvider
extends AbstractCartesianAdjointDerivativesProvider
implements AdditionalDerivativesProvider {
    private final CartesianAdjointEquationTerm[] adjointEquationTerms;

    public CartesianAdjointDerivativesProvider(CartesianCost cost, CartesianAdjointEquationTerm ... adjointEquationTerms) {
        super(cost);
        this.adjointEquationTerms = adjointEquationTerms;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        AdditionalDerivativesProvider.super.init(initialState, target);
        if (initialState.isOrbitDefined() && initialState.getOrbit().getType() != OrbitType.CARTESIAN) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_COORDINATES_FOR_ADJOINT_EQUATION, new Object[0]);
        }
    }

    @Override
    public CombinedDerivatives combinedDerivatives(SpacecraftState state) {
        double[] adjointVariables = state.getAdditionalState(this.getName());
        int adjointDimension = this.getDimension();
        double[] additionalDerivatives = new double[adjointDimension];
        double[] cartesianVariablesAndMass = this.formCartesianAndMassVector(state);
        double mass = state.getMass();
        double[] mainDerivativesIncrements = new double[7];
        Vector3D thrustAccelerationVector = this.getCost().getThrustAccelerationVector(adjointVariables, mass);
        mainDerivativesIncrements[3] = thrustAccelerationVector.getX();
        mainDerivativesIncrements[4] = thrustAccelerationVector.getY();
        mainDerivativesIncrements[5] = thrustAccelerationVector.getZ();
        mainDerivativesIncrements[6] = -this.getCost().getMassFlowRateFactor() * thrustAccelerationVector.getNorm() * mass;
        additionalDerivatives[3] = -adjointVariables[0];
        additionalDerivatives[4] = -adjointVariables[1];
        additionalDerivatives[5] = -adjointVariables[2];
        AbsoluteDate date = state.getDate();
        Frame propagationFrame = state.getFrame();
        for (CartesianAdjointEquationTerm equationTerm : this.adjointEquationTerms) {
            double[] contribution = equationTerm.getRatesContribution(date, cartesianVariablesAndMass, adjointVariables, propagationFrame);
            for (int i = 0; i < FastMath.min((int)adjointDimension, (int)contribution.length); ++i) {
                int n = i;
                additionalDerivatives[n] = additionalDerivatives[n] + contribution[i];
            }
        }
        this.getCost().updateAdjointDerivatives(adjointVariables, mass, additionalDerivatives);
        return new CombinedDerivatives(additionalDerivatives, mainDerivativesIncrements);
    }

    private double[] formCartesianAndMassVector(SpacecraftState state) {
        double mass;
        double[] cartesianVariablesAndMass = new double[7];
        TimeStampedPVCoordinates pvCoordinates = state.getPVCoordinates();
        System.arraycopy(pvCoordinates.getPosition().toArray(), 0, cartesianVariablesAndMass, 0, 3);
        System.arraycopy(pvCoordinates.getVelocity().toArray(), 0, cartesianVariablesAndMass, 3, 3);
        cartesianVariablesAndMass[6] = mass = state.getMass();
        return cartesianVariablesAndMass;
    }

    public double evaluateHamiltonian(SpacecraftState state) {
        double[] cartesianAndMassVector = this.formCartesianAndMassVector(state);
        double[] adjointVariables = state.getAdditionalState(this.getName());
        double hamiltonian = adjointVariables[0] * cartesianAndMassVector[3] + adjointVariables[1] * cartesianAndMassVector[4] + adjointVariables[2] * cartesianAndMassVector[5];
        AbsoluteDate date = state.getDate();
        Frame propagationFrame = state.getFrame();
        for (CartesianAdjointEquationTerm adjointEquationTerm : this.adjointEquationTerms) {
            hamiltonian += adjointEquationTerm.getHamiltonianContribution(date, adjointVariables, adjointVariables, propagationFrame);
        }
        if (adjointVariables.length != 6) {
            double mass = state.getMass();
            double thrustAccelerationNorm = this.getCost().getThrustAccelerationVector(adjointVariables, mass).getNorm();
            hamiltonian -= this.getCost().getMassFlowRateFactor() * adjointVariables[6] * thrustAccelerationNorm * mass;
        }
        return hamiltonian += this.getCost().getHamiltonianContribution(adjointVariables, state.getMass());
    }
}

