/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointNewtonianTerm;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPositionProvider;

public abstract class AbstractCartesianAdjointNonCentralBodyTerm
extends AbstractCartesianAdjointNewtonianTerm {
    private final ExtendedPositionProvider bodyPositionProvider;

    protected AbstractCartesianAdjointNonCentralBodyTerm(double mu, ExtendedPositionProvider bodyPositionProvider) {
        super(mu);
        this.bodyPositionProvider = bodyPositionProvider;
    }

    @Override
    public double[] getPositionAdjointContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        return this.getNewtonianVelocityAdjointContribution(this.formRelativePosition(date, stateVariables, frame), adjointVariables);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] getPositionAdjointFieldContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        return this.getFieldNewtonianVelocityAdjointContribution(this.formFieldRelativePosition(date, (CalculusFieldElement[])stateVariables, frame), (CalculusFieldElement[])adjointVariables);
    }

    protected Vector3D getBodyPosition(AbsoluteDate date, Frame frame) {
        return this.bodyPositionProvider.getPosition(date, frame);
    }

    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldBodyPosition(FieldAbsoluteDate<T> date, Frame frame) {
        return this.bodyPositionProvider.getPosition(date, frame);
    }

    protected double[] formRelativePosition(AbsoluteDate date, double[] stateVariables, Frame frame) {
        Vector3D bodyPosition = this.getBodyPosition(date, frame);
        double x = stateVariables[0] - bodyPosition.getX();
        double y = stateVariables[1] - bodyPosition.getY();
        double z = stateVariables[2] - bodyPosition.getZ();
        return new double[]{x, y, z};
    }

    protected <T extends CalculusFieldElement<T>> T[] formFieldRelativePosition(FieldAbsoluteDate<T> date, T[] stateVariables, Frame frame) {
        FieldVector3D<T> bodyPosition = this.getFieldBodyPosition(date, frame);
        CalculusFieldElement x = (CalculusFieldElement)stateVariables[0].subtract((FieldElement)bodyPosition.getX());
        CalculusFieldElement y = (CalculusFieldElement)stateVariables[1].subtract((FieldElement)bodyPosition.getY());
        CalculusFieldElement z = (CalculusFieldElement)stateVariables[2].subtract((FieldElement)bodyPosition.getZ());
        CalculusFieldElement[] relativePosition = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
        relativePosition[0] = x;
        relativePosition[1] = y;
        relativePosition[2] = z;
        return relativePosition;
    }
}

