/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointGravitationalTerm;

public abstract class AbstractCartesianAdjointNewtonianTerm
extends AbstractCartesianAdjointGravitationalTerm {
    private static final double MINUS_THREE = -3.0;

    protected AbstractCartesianAdjointNewtonianTerm(double mu) {
        super(mu);
    }

    protected double[] getNewtonianVelocityAdjointContribution(double[] relativePosition, double[] adjointVariables) {
        double[] contribution = new double[3];
        double x = relativePosition[0];
        double y = relativePosition[1];
        double z = relativePosition[2];
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double factor = this.getMu() / (r2 * r2 * r);
        double xy = x * y;
        double xz = x * z;
        double yz = y * z;
        double pvx = adjointVariables[3];
        double pvy = adjointVariables[4];
        double pvz = adjointVariables[5];
        contribution[0] = ((x2 * -3.0 + r2) * pvx + xy * -3.0 * pvy + xz * -3.0 * pvz) * factor;
        contribution[1] = ((y2 * -3.0 + r2) * pvy + xy * -3.0 * pvx + yz * -3.0 * pvz) * factor;
        contribution[2] = ((z2 * -3.0 + r2) * pvz + yz * -3.0 * pvy + xz * -3.0 * pvx) * factor;
        return contribution;
    }

    protected <T extends CalculusFieldElement<T>> T[] getFieldNewtonianVelocityAdjointContribution(T[] relativePosition, T[] adjointVariables) {
        CalculusFieldElement[] contribution = (CalculusFieldElement[])MathArrays.buildArray((Field)adjointVariables[0].getField(), (int)3);
        T x = relativePosition[0];
        T y = relativePosition[1];
        T z = relativePosition[2];
        CalculusFieldElement x2 = (CalculusFieldElement)x.multiply(x);
        CalculusFieldElement y2 = (CalculusFieldElement)y.multiply(y);
        CalculusFieldElement z2 = (CalculusFieldElement)z.multiply(z);
        CalculusFieldElement r2 = (CalculusFieldElement)((CalculusFieldElement)x2.add((FieldElement)y2)).add((FieldElement)z2);
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)r2)).multiply((FieldElement)r)).reciprocal()).multiply(this.getMu());
        CalculusFieldElement xy = (CalculusFieldElement)x.multiply(y);
        CalculusFieldElement xz = (CalculusFieldElement)x.multiply(z);
        CalculusFieldElement yz = (CalculusFieldElement)y.multiply(z);
        T pvx = adjointVariables[3];
        T pvy = adjointVariables[4];
        T pvz = adjointVariables[5];
        contribution[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply(-3.0)).add((FieldElement)r2)).multiply(pvx)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)xy.multiply(-3.0)).multiply(pvy)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)xz.multiply(-3.0)).multiply(pvz)))).multiply((FieldElement)factor);
        contribution[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xy.multiply(-3.0)).multiply(pvx)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.multiply(-3.0)).add((FieldElement)r2)).multiply(pvy)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)yz.multiply(-3.0)).multiply(pvz)))).multiply((FieldElement)factor);
        contribution[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xz.multiply(-3.0)).multiply(pvx)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)yz.multiply(-3.0)).multiply(pvy)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)z2.multiply(-3.0)).add((FieldElement)r2)).multiply(pvz)))).multiply((FieldElement)factor);
        return contribution;
    }

    protected Vector3D getNewtonianAcceleration(double[] position) {
        Vector3D positionVector = new Vector3D(position[0], position[1], position[2]);
        double squaredRadius = positionVector.getNormSq();
        double factor = -this.getMu() / (squaredRadius * FastMath.sqrt((double)squaredRadius));
        return positionVector.scalarMultiply(factor);
    }

    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldNewtonianAcceleration(T[] position) {
        FieldVector3D positionVector = new FieldVector3D(position[0], position[1], position[2]);
        CalculusFieldElement squaredRadius = positionVector.getNormSq();
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)squaredRadius.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)squaredRadius))).reciprocal()).multiply(-this.getMu());
        return positionVector.scalarMultiply(factor);
    }
}

