/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.AbstractCartesianAdjointEquationTerm;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public abstract class AbstractCartesianAdjointGravitationalTerm
extends AbstractCartesianAdjointEquationTerm {
    private final double mu;

    protected AbstractCartesianAdjointGravitationalTerm(double mu) {
        this.mu = mu;
    }

    public double getMu() {
        return this.mu;
    }

    @Override
    public double[] getRatesContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        double[] contribution = new double[adjointVariables.length];
        double[] positionAdjointContribution = this.getPositionAdjointContribution(date, stateVariables, adjointVariables, frame);
        System.arraycopy(positionAdjointContribution, 0, contribution, 0, positionAdjointContribution.length);
        return contribution;
    }

    protected abstract double[] getPositionAdjointContribution(AbsoluteDate var1, double[] var2, double[] var3, Frame var4);

    @Override
    public <T extends CalculusFieldElement<T>> T[] getFieldRatesContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        CalculusFieldElement[] contribution = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)adjointVariables.length);
        CalculusFieldElement[] positionAdjointFieldContribution = this.getPositionAdjointFieldContribution(date, (CalculusFieldElement[])stateVariables, (CalculusFieldElement[])adjointVariables, frame);
        System.arraycopy(positionAdjointFieldContribution, 0, contribution, 0, positionAdjointFieldContribution.length);
        return contribution;
    }

    protected abstract <T extends CalculusFieldElement<T>> T[] getPositionAdjointFieldContribution(FieldAbsoluteDate<T> var1, T[] var2, T[] var3, Frame var4);
}

