/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.control.indirect.adjoint;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.analysis.differentiation.FieldGradientField;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.control.indirect.adjoint.CartesianAdjointEquationTerm;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public abstract class AbstractCartesianAdjointEquationTerm
implements CartesianAdjointEquationTerm {
    private static final int GRADIENT_DIMENSION = 6;

    @Override
    public double[] getRatesContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        GradientField field = GradientField.getField((int)6);
        FieldAbsoluteDate fieldDate = new FieldAbsoluteDate(field, date);
        Gradient[] stateAsGradients = AbstractCartesianAdjointEquationTerm.buildGradientCartesianVector(stateVariables);
        FieldVector3D acceleration = this.getFieldAcceleration(fieldDate, (CalculusFieldElement[])stateAsGradients, frame);
        double[] accelerationXgradient = ((Gradient)acceleration.getX()).getGradient();
        double[] accelerationYgradient = ((Gradient)acceleration.getY()).getGradient();
        double[] accelerationZgradient = ((Gradient)acceleration.getZ()).getGradient();
        double[] contribution = new double[adjointVariables.length];
        for (int i = 0; i < 6; ++i) {
            contribution[i] = -(accelerationXgradient[i] * adjointVariables[3] + accelerationYgradient[i] * adjointVariables[4] + accelerationZgradient[i] * adjointVariables[5]);
        }
        return contribution;
    }

    @Override
    public double getHamiltonianContribution(AbsoluteDate date, double[] stateVariables, double[] adjointVariables, Frame frame) {
        Vector3D acceleration = this.getAcceleration(date, stateVariables, frame);
        return acceleration.getX() * adjointVariables[3] + acceleration.getY() * adjointVariables[4] + acceleration.getZ() * adjointVariables[5];
    }

    protected abstract Vector3D getAcceleration(AbsoluteDate var1, double[] var2, Frame var3);

    @Override
    public <T extends CalculusFieldElement<T>> T[] getFieldRatesContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        FieldGradientField field = FieldGradientField.getField(date.getField(), (int)6);
        FieldAbsoluteDate fieldDate = new FieldAbsoluteDate(field, date.toAbsoluteDate());
        FieldGradient[] gradients = AbstractCartesianAdjointEquationTerm.buildFieldGradientCartesianVector(stateVariables);
        FieldVector3D acceleration = this.getFieldAcceleration(fieldDate, (CalculusFieldElement[])gradients, frame);
        CalculusFieldElement[] contribution = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)adjointVariables.length);
        CalculusFieldElement[] accelerationXgradient = ((FieldGradient)acceleration.getX()).getGradient();
        CalculusFieldElement[] accelerationYgradient = ((FieldGradient)acceleration.getY()).getGradient();
        CalculusFieldElement[] accelerationZgradient = ((FieldGradient)acceleration.getZ()).getGradient();
        for (int i = 0; i < 6; ++i) {
            contribution[i] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)accelerationXgradient[i].multiply(adjointVariables[3])).add((FieldElement)((CalculusFieldElement)accelerationYgradient[i].multiply(adjointVariables[4])))).add((FieldElement)((CalculusFieldElement)accelerationZgradient[i].multiply(adjointVariables[5])))).negate();
        }
        return contribution;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getFieldHamiltonianContribution(FieldAbsoluteDate<T> date, T[] stateVariables, T[] adjointVariables, Frame frame) {
        FieldVector3D acceleration = this.getFieldAcceleration(date, (CalculusFieldElement[])stateVariables, frame);
        return (T)acceleration.dotProduct(new FieldVector3D(adjointVariables[3], adjointVariables[4], adjointVariables[5]));
    }

    protected abstract <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldAcceleration(FieldAbsoluteDate<T> var1, T[] var2, Frame var3);

    protected static Gradient[] buildGradientCartesianVector(double[] stateVariables) {
        GradientField field = GradientField.getField((int)6);
        Gradient[] gradients = (Gradient[])MathArrays.buildArray((Field)field, (int)6);
        gradients[0] = Gradient.variable((int)6, (int)0, (double)stateVariables[0]);
        gradients[1] = Gradient.variable((int)6, (int)1, (double)stateVariables[1]);
        gradients[2] = Gradient.variable((int)6, (int)2, (double)stateVariables[2]);
        gradients[3] = Gradient.variable((int)6, (int)3, (double)stateVariables[3]);
        gradients[4] = Gradient.variable((int)6, (int)4, (double)stateVariables[4]);
        gradients[5] = Gradient.variable((int)6, (int)5, (double)stateVariables[5]);
        return gradients;
    }

    protected static <T extends CalculusFieldElement<T>> FieldGradient<T>[] buildFieldGradientCartesianVector(T[] stateVariables) {
        FieldGradientField field = FieldGradientField.getField((Field)stateVariables[0].getField(), (int)6);
        FieldGradient[] gradients = (FieldGradient[])MathArrays.buildArray((Field)field, (int)6);
        gradients[0] = FieldGradient.variable((int)6, (int)0, stateVariables[0]);
        gradients[1] = FieldGradient.variable((int)6, (int)1, stateVariables[1]);
        gradients[2] = FieldGradient.variable((int)6, (int)2, stateVariables[2]);
        gradients[3] = FieldGradient.variable((int)6, (int)3, stateVariables[3]);
        gradients[4] = FieldGradient.variable((int)6, (int)4, stateVariables[4]);
        gradients[5] = FieldGradient.variable((int)6, (int)5, stateVariables[5]);
        return gradients;
    }
}

