/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

class PosVelChebyshev
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = 20151023L;
    private final TimeScale timeScale;
    private final AbsoluteDate start;
    private final double duration;
    private final double[] xCoeffs;
    private final double[] yCoeffs;
    private final double[] zCoeffs;
    private final double vScale;
    private final double aScale;

    PosVelChebyshev(AbsoluteDate start, TimeScale timeScale, double duration, double[] xCoeffs, double[] yCoeffs, double[] zCoeffs) {
        this.start = start;
        this.timeScale = timeScale;
        this.duration = duration;
        this.xCoeffs = xCoeffs;
        this.yCoeffs = yCoeffs;
        this.zCoeffs = zCoeffs;
        this.vScale = 2.0 / duration;
        this.aScale = this.vScale * this.vScale;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.start;
    }

    private double computeValueIndependentVariable(AbsoluteDate date) {
        return (2.0 * date.offsetFrom(this.start, this.timeScale) - this.duration) / this.duration;
    }

    private <T extends CalculusFieldElement<T>> T computeValueIndependentVariable(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)date.offsetFrom(new FieldAbsoluteDate<T>(date.getField(), this.start), this.timeScale).multiply(2)).subtract(this.duration)).divide(this.duration));
    }

    public boolean inRange(AbsoluteDate date) {
        double dt = date.offsetFrom(this.start, this.timeScale);
        return dt >= -0.001 && dt <= this.duration + 0.001;
    }

    Vector3D getPosition(AbsoluteDate date) {
        double t = this.computeValueIndependentVariable(date);
        double twoT = 2.0 * t;
        double pKm1 = 1.0;
        double pK = t;
        double xP = this.xCoeffs[0];
        double yP = this.yCoeffs[0];
        double zP = this.zCoeffs[0];
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP += this.xCoeffs[k] * pK;
            yP += this.yCoeffs[k] * pK;
            zP += this.zCoeffs[k] * pK;
            double pKm2 = pKm1;
            pKm1 = pK;
            pK = twoT * pKm1 - pKm2;
        }
        return new Vector3D(xP, yP, zP);
    }

    <T extends CalculusFieldElement<T>> FieldVector3D<T> getPosition(FieldAbsoluteDate<T> date) {
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)date.getField().getOne();
        T t = this.computeValueIndependentVariable(date);
        CalculusFieldElement twoT = (CalculusFieldElement)t.add(t);
        Object pKm1 = one;
        Object pK = t;
        CalculusFieldElement xP = (CalculusFieldElement)zero.newInstance(this.xCoeffs[0]);
        CalculusFieldElement yP = (CalculusFieldElement)zero.newInstance(this.yCoeffs[0]);
        CalculusFieldElement zP = (CalculusFieldElement)zero.newInstance(this.zCoeffs[0]);
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP = (CalculusFieldElement)xP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.xCoeffs[k])));
            yP = (CalculusFieldElement)yP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.yCoeffs[k])));
            zP = (CalculusFieldElement)zP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.zCoeffs[k])));
            CalculusFieldElement pKm2 = pKm1;
            pKm1 = pK;
            pK = (CalculusFieldElement)((CalculusFieldElement)twoT.multiply((FieldElement)pKm1)).subtract((FieldElement)pKm2);
        }
        return new FieldVector3D(xP, yP, zP);
    }

    PVCoordinates getPositionVelocityAcceleration(AbsoluteDate date) {
        double t = this.computeValueIndependentVariable(date);
        double twoT = 2.0 * t;
        double pKm1 = 1.0;
        double pK = t;
        double xP = this.xCoeffs[0];
        double yP = this.yCoeffs[0];
        double zP = this.zCoeffs[0];
        double qKm1 = 0.0;
        double qK = 1.0;
        double xV = 0.0;
        double yV = 0.0;
        double zV = 0.0;
        double rKm1 = 0.0;
        double rK = 0.0;
        double xA = 0.0;
        double yA = 0.0;
        double zA = 0.0;
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP += this.xCoeffs[k] * pK;
            yP += this.yCoeffs[k] * pK;
            zP += this.zCoeffs[k] * pK;
            xV += this.xCoeffs[k] * qK;
            yV += this.yCoeffs[k] * qK;
            zV += this.zCoeffs[k] * qK;
            xA += this.xCoeffs[k] * rK;
            yA += this.yCoeffs[k] * rK;
            zA += this.zCoeffs[k] * rK;
            double pKm2 = pKm1;
            pKm1 = pK;
            pK = twoT * pKm1 - pKm2;
            double qKm2 = qKm1;
            qKm1 = qK;
            qK = twoT * qKm1 + 2.0 * pKm1 - qKm2;
            double rKm2 = rKm1;
            rKm1 = rK;
            rK = twoT * rKm1 + 4.0 * qKm1 - rKm2;
        }
        return new PVCoordinates(new Vector3D(xP, yP, zP), new Vector3D(xV * this.vScale, yV * this.vScale, zV * this.vScale), new Vector3D(xA * this.aScale, yA * this.aScale, zA * this.aScale));
    }

    <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> getPositionVelocityAcceleration(FieldAbsoluteDate<T> date) {
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)date.getField().getOne();
        T t = this.computeValueIndependentVariable(date);
        CalculusFieldElement twoT = (CalculusFieldElement)t.add(t);
        Object pKm1 = one;
        Object pK = t;
        CalculusFieldElement xP = (CalculusFieldElement)zero.newInstance(this.xCoeffs[0]);
        CalculusFieldElement yP = (CalculusFieldElement)zero.newInstance(this.yCoeffs[0]);
        CalculusFieldElement zP = (CalculusFieldElement)zero.newInstance(this.zCoeffs[0]);
        CalculusFieldElement qKm1 = zero;
        CalculusFieldElement qK = one;
        CalculusFieldElement xV = zero;
        CalculusFieldElement yV = zero;
        CalculusFieldElement zV = zero;
        CalculusFieldElement rKm1 = zero;
        CalculusFieldElement rK = zero;
        CalculusFieldElement xA = zero;
        CalculusFieldElement yA = zero;
        CalculusFieldElement zA = zero;
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP = (CalculusFieldElement)xP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.xCoeffs[k])));
            yP = (CalculusFieldElement)yP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.yCoeffs[k])));
            zP = (CalculusFieldElement)zP.add((FieldElement)((CalculusFieldElement)pK.multiply(this.zCoeffs[k])));
            xV = (CalculusFieldElement)xV.add((FieldElement)((CalculusFieldElement)qK.multiply(this.xCoeffs[k])));
            yV = (CalculusFieldElement)yV.add((FieldElement)((CalculusFieldElement)qK.multiply(this.yCoeffs[k])));
            zV = (CalculusFieldElement)zV.add((FieldElement)((CalculusFieldElement)qK.multiply(this.zCoeffs[k])));
            xA = (CalculusFieldElement)xA.add((FieldElement)((CalculusFieldElement)rK.multiply(this.xCoeffs[k])));
            yA = (CalculusFieldElement)yA.add((FieldElement)((CalculusFieldElement)rK.multiply(this.yCoeffs[k])));
            zA = (CalculusFieldElement)zA.add((FieldElement)((CalculusFieldElement)rK.multiply(this.zCoeffs[k])));
            CalculusFieldElement pKm2 = pKm1;
            pKm1 = pK;
            pK = (CalculusFieldElement)((CalculusFieldElement)twoT.multiply((FieldElement)pKm1)).subtract((FieldElement)pKm2);
            CalculusFieldElement qKm2 = qKm1;
            qKm1 = qK;
            qK = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)twoT.multiply((FieldElement)qKm1)).add((FieldElement)((CalculusFieldElement)pKm1.multiply(2)))).subtract((FieldElement)qKm2);
            CalculusFieldElement rKm2 = rKm1;
            rKm1 = rK;
            rK = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)twoT.multiply((FieldElement)rKm1)).add((FieldElement)((CalculusFieldElement)qKm1.multiply(4)))).subtract((FieldElement)rKm2);
        }
        return new FieldPVCoordinates(new FieldVector3D(xP, yP, zP), new FieldVector3D((CalculusFieldElement)xV.multiply(this.vScale), (CalculusFieldElement)yV.multiply(this.vScale), (CalculusFieldElement)zV.multiply(this.vScale)), new FieldVector3D((CalculusFieldElement)xA.multiply(this.aScale), (CalculusFieldElement)yA.multiply(this.aScale), (CalculusFieldElement)zA.multiply(this.aScale)));
    }
}

