/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import java.util.function.DoubleFunction;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.Ellipsoid;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneAxisEllipsoid
extends Ellipsoid
implements BodyShape {
    private static final long serialVersionUID = 20130518L;
    private static final double ANGULAR_THRESHOLD = 1.0E-4;
    private final Frame bodyFrame;
    private final double ae2;
    private final double ap2;
    private final double f;
    private final double e;
    private final double e2;
    private final double g;
    private final double g2;
    private double angularThreshold;

    public OneAxisEllipsoid(double ae, double f, Frame bodyFrame) {
        super(bodyFrame, ae, ae, ae * (1.0 - f));
        this.f = f;
        this.ae2 = ae * ae;
        this.e2 = f * (2.0 - f);
        this.e = FastMath.sqrt((double)this.e2);
        this.g = 1.0 - f;
        this.g2 = this.g * this.g;
        this.ap2 = this.ae2 * this.g2;
        this.setAngularThreshold(1.0E-12);
        this.bodyFrame = bodyFrame;
    }

    public void setAngularThreshold(double angularThreshold) {
        this.angularThreshold = angularThreshold;
    }

    public double getEquatorialRadius() {
        return this.getA();
    }

    public double getFlattening() {
        return this.f;
    }

    public double getEccentricitySquared() {
        return this.e2;
    }

    public double getEccentricity() {
        return this.e;
    }

    @Override
    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    public Vector3D getCartesianIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        double c;
        double cz2;
        double a;
        double ac;
        double dz;
        double dy;
        StaticTransform frameToBodyFrame = frame.getStaticTransformTo(this.bodyFrame, date);
        Line lineInBodyFrame = frameToBodyFrame.transformLine(line);
        Vector3D point = lineInBodyFrame.getOrigin();
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double z2 = z * z;
        double r2 = x * x + y * y;
        Vector3D direction = lineInBodyFrame.getDirection();
        double dx = direction.getX();
        double b = -(this.g2 * (x * dx + y * (dy = direction.getY())) + z * (dz = direction.getZ()));
        double b2 = b * b;
        if (b2 < (ac = (a = 1.0 - this.e2 * (cz2 = dx * dx + dy * dy)) * (c = this.g2 * (r2 - this.ae2) + z2))) {
            return null;
        }
        double s = FastMath.sqrt((double)(b2 - ac));
        double k1 = b < 0.0 ? (b - s) / a : c / (b + s);
        double k2 = c / (a * k1);
        Vector3D closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        double closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        double k = FastMath.abs((double)(k1 - closeAbscissa)) < FastMath.abs((double)(k2 - closeAbscissa)) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public GeodeticPoint getIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        Vector3D intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        double ix = intersection.getX();
        double iy = intersection.getY();
        double iz = intersection.getZ();
        double lambda = FastMath.atan2((double)iy, (double)ix);
        double phi = FastMath.atan2((double)iz, (double)(this.g2 * FastMath.sqrt((double)(ix * ix + iy * iy))));
        return new GeodeticPoint(phi, lambda, 0.0);
    }

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getCartesianIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldStaticTransform<T> frameToBodyFrame = frame.getStaticTransformTo(this.bodyFrame, date);
        FieldLine<T> lineInBodyFrame = frameToBodyFrame.transformLine(line);
        FieldVector3D point = lineInBodyFrame.getOrigin();
        CalculusFieldElement x = point.getX();
        CalculusFieldElement y = point.getY();
        CalculusFieldElement z = point.getZ();
        CalculusFieldElement z2 = (CalculusFieldElement)z.square();
        CalculusFieldElement r2 = (CalculusFieldElement)((CalculusFieldElement)x.square()).add((FieldElement)((CalculusFieldElement)y.square()));
        FieldVector3D direction = lineInBodyFrame.getDirection();
        CalculusFieldElement dx = direction.getX();
        CalculusFieldElement dy = direction.getY();
        CalculusFieldElement dz = direction.getZ();
        CalculusFieldElement cz2 = (CalculusFieldElement)((CalculusFieldElement)dx.square()).add((FieldElement)((CalculusFieldElement)dy.square()));
        CalculusFieldElement a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cz2.multiply(this.e2)).subtract(1.0)).negate();
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)dx)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)dy)))).multiply(this.g2)).add((FieldElement)((CalculusFieldElement)z.multiply((FieldElement)dz)))).negate();
        CalculusFieldElement c = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.subtract(this.ae2)).multiply(this.g2)).add((FieldElement)z2);
        CalculusFieldElement b2 = (CalculusFieldElement)b.square();
        CalculusFieldElement ac = (CalculusFieldElement)a.multiply((FieldElement)c);
        if (b2.getReal() < ac.getReal()) {
            return null;
        }
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)b2.subtract((FieldElement)ac)).sqrt();
        CalculusFieldElement k1 = b.getReal() < 0.0 ? (CalculusFieldElement)((CalculusFieldElement)b.subtract((FieldElement)s)).divide((FieldElement)a) : (CalculusFieldElement)c.divide((FieldElement)((CalculusFieldElement)b.add((FieldElement)s)));
        CalculusFieldElement k2 = (CalculusFieldElement)c.divide((FieldElement)((CalculusFieldElement)a.multiply((FieldElement)k1)));
        FieldVector3D<T> closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        CalculusFieldElement closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        CalculusFieldElement k = FastMath.abs((double)(k1.getReal() - closeAbscissa.getReal())) < FastMath.abs((double)(k2.getReal() - closeAbscissa.getReal())) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> getIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        CalculusFieldElement ix = intersection.getX();
        CalculusFieldElement iy = intersection.getY();
        CalculusFieldElement iz = intersection.getZ();
        CalculusFieldElement lambda = (CalculusFieldElement)iy.atan2((FieldElement)ix);
        CalculusFieldElement phi = (CalculusFieldElement)iz.atan2((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ix.multiply((FieldElement)ix)).add((FieldElement)((CalculusFieldElement)iy.multiply((FieldElement)iy)))).sqrt()).multiply(this.g2)));
        return new FieldGeodeticPoint<CalculusFieldElement>(phi, lambda, (CalculusFieldElement)phi.getField().getZero());
    }

    @Override
    public Vector3D transform(GeodeticPoint point) {
        double longitude = point.getLongitude();
        SinCos scLambda = FastMath.sinCos((double)longitude);
        double latitude = point.getLatitude();
        SinCos scPhi = FastMath.sinCos((double)latitude);
        double h = point.getAltitude();
        double n = this.getA() / FastMath.sqrt((double)(1.0 - this.e2 * scPhi.sin() * scPhi.sin()));
        double r = (n + h) * scPhi.cos();
        return new Vector3D(r * scLambda.cos(), r * scLambda.sin(), (this.g2 * n + h) * scPhi.sin());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> transform(FieldGeodeticPoint<T> point) {
        T latitude = point.getLatitude();
        T longitude = point.getLongitude();
        T altitude = point.getAltitude();
        FieldSinCos scLambda = FastMath.sinCos(longitude);
        FieldSinCos scPhi = FastMath.sinCos(latitude);
        CalculusFieldElement cLambda = (CalculusFieldElement)scLambda.cos();
        CalculusFieldElement sLambda = (CalculusFieldElement)scLambda.sin();
        CalculusFieldElement cPhi = (CalculusFieldElement)scPhi.cos();
        CalculusFieldElement sPhi = (CalculusFieldElement)scPhi.sin();
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sPhi.multiply((FieldElement)sPhi)).multiply(this.e2)).subtract(1.0)).negate()).sqrt()).reciprocal()).multiply(this.getA());
        CalculusFieldElement r = (CalculusFieldElement)((CalculusFieldElement)n.add(altitude)).multiply((FieldElement)cPhi);
        return new FieldVector3D((CalculusFieldElement)r.multiply((FieldElement)cLambda), (CalculusFieldElement)r.multiply((FieldElement)sLambda), (CalculusFieldElement)sPhi.multiply((FieldElement)((CalculusFieldElement)altitude.add((FieldElement)((CalculusFieldElement)n.multiply(this.g2))))));
    }

    @Override
    public Vector3D projectToGround(Vector3D point, AbsoluteDate date, Frame frame) {
        StaticTransform toBody = frame.getStaticTransformTo(this.bodyFrame, date);
        Vector3D p = toBody.transformPosition(point);
        double z = p.getZ();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Ellipse meridian = new Ellipse(Vector3D.ZERO, r == 0.0 ? Vector3D.PLUS_I : new Vector3D(p.getX() / r, p.getY() / r, 0.0), Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        Vector3D groundPoint = meridian.toSpace(meridian.projectToEllipse(new Vector2D(r, z)));
        return toBody.getInverse().transformPosition(groundPoint);
    }

    @Override
    public TimeStampedPVCoordinates projectToGround(TimeStampedPVCoordinates pv, Frame frame) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, pv.getDate());
        TimeStampedPVCoordinates pvInBodyFrame = toBody.transformPVCoordinates(pv);
        Vector3D p = pvInBodyFrame.getPosition();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Vector3D meridian = r == 0.0 ? Vector3D.PLUS_I : new Vector3D(p.getX() / r, p.getY() / r, 0.0);
        Ellipse firstPrincipalCurvature = new Ellipse(Vector3D.ZERO, meridian, Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        TimeStampedPVCoordinates gpFirst = firstPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpP = gpFirst.getPosition();
        double gr = MathArrays.linearCombination((double)gpP.getX(), (double)meridian.getX(), (double)gpP.getY(), (double)meridian.getY());
        double gz = gpP.getZ();
        Vector3D east = new Vector3D(-meridian.getY(), meridian.getX(), 0.0);
        Vector3D zenith = (Vector3D)new Vector3D(gr * this.getC() / this.getA(), meridian, gz * this.getA() / this.getC(), Vector3D.PLUS_K).normalize();
        Vector3D north = Vector3D.crossProduct((Vector3D)zenith, (Vector3D)east);
        Ellipse secondPrincipalCurvature = this.getPlaneSection(gpP, north);
        TimeStampedPVCoordinates gpSecond = secondPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpV = gpFirst.getVelocity().add((Vector)gpSecond.getVelocity());
        Vector3D gpA = gpFirst.getAcceleration().add((Vector)gpSecond.getAcceleration());
        TimeStampedPVCoordinates groundPV = new TimeStampedPVCoordinates(pv.getDate(), gpP, gpV, gpA);
        return toBody.getInverse().transformPVCoordinates(groundPV);
    }

    @Override
    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) {
        double h;
        double phi;
        Vector3D pointInBodyFrame = frame.getStaticTransformTo(this.bodyFrame, date).transformPosition(point);
        double r2 = pointInBodyFrame.getX() * pointInBodyFrame.getX() + pointInBodyFrame.getY() * pointInBodyFrame.getY();
        double r = FastMath.sqrt((double)r2);
        double z = pointInBodyFrame.getZ();
        double lambda = FastMath.atan2((double)pointInBodyFrame.getY(), (double)pointInBodyFrame.getX());
        if (r <= 1.0E-4 * FastMath.abs((double)z)) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign((double)(this.getA() * this.e2 / this.g), (double)(-z));
            double deltaZ = z - evoluteCuspZ;
            phi = FastMath.copySign((double)(1.5707963267948966 - FastMath.atan((double)(r / FastMath.abs((double)deltaZ)))), (double)deltaZ);
            h = FastMath.hypot((double)deltaZ, (double)r) - osculatingRadius;
        } else if (FastMath.abs((double)z) <= 1.0E-4 * r) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            double deltaR = r - evoluteCuspR;
            if (deltaR >= 0.0) {
                phi = deltaR == 0.0 ? 0.0 : FastMath.atan((double)(z / deltaR));
                h = FastMath.hypot((double)deltaR, (double)z) - osculatingRadius;
            } else {
                double rClose = r / this.e2;
                double zClose = FastMath.copySign((double)(this.g * FastMath.sqrt((double)(this.ae2 - rClose * rClose))), (double)z);
                phi = FastMath.atan((double)((zClose - z) / (rClose - r)));
                h = -FastMath.hypot((double)(r - rClose), (double)(z - zClose));
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * FastMath.max((double)this.getA(), (double)FastMath.sqrt((double)(r2 + z * z)));
            double c = this.getA() * this.e2;
            double absZ = FastMath.abs((double)z);
            double zc = this.g * absZ;
            double sn = absZ;
            double sn2 = sn * sn;
            double cn = this.g * r;
            double cn2 = cn * cn;
            double an2 = cn2 + sn2;
            double an = FastMath.sqrt((double)an2);
            double bn = 0.0;
            phi = Double.POSITIVE_INFINITY;
            h = Double.POSITIVE_INFINITY;
            for (int i = 0; i < 1000; ++i) {
                double oldSn = sn;
                double oldCn = cn;
                double oldPhi = phi;
                double oldH = h;
                double an3 = an2 * an;
                double csncn = c * sn * cn;
                bn = 1.5 * csncn * ((r * sn - zc * cn) * an - csncn);
                sn = (zc * an3 + c * sn2 * sn) * an3 - bn * sn;
                cn = (r * an3 - c * cn2 * cn) * an3 - bn * cn;
                if (sn * oldSn < 0.0 || cn < 0.0) {
                    while (sn * oldSn < 0.0 || cn < 0.0) {
                        sn = (sn + oldSn) / 2.0;
                        cn = (cn + oldCn) / 2.0;
                    }
                    continue;
                }
                int exp = (FastMath.getExponent((double)sn) + FastMath.getExponent((double)cn)) / 2;
                sn = FastMath.scalb((double)sn, (int)(-exp));
                cn = FastMath.scalb((double)cn, (int)(-exp));
                sn2 = sn * sn;
                cn2 = cn * cn;
                an2 = cn2 + sn2;
                an = FastMath.sqrt((double)an2);
                double cc = this.g * cn;
                h = (r * cc + absZ * sn - this.getA() * this.g * an) / FastMath.sqrt((double)(an2 - this.e2 * cn2));
                if (FastMath.abs((double)(oldH - h)) < epsH && FastMath.abs((double)(oldPhi - (phi = FastMath.copySign((double)FastMath.atan((double)(sn / cc)), (double)z)))) < 1.0E-15) break;
            }
            if (Double.isInfinite(phi)) {
                phi = FastMath.copySign((double)FastMath.atan((double)(sn / (this.g * cn))), (double)z);
            }
        }
        return new GeodeticPoint(phi, lambda, h);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> transform(FieldVector3D<T> point, Frame frame, FieldAbsoluteDate<T> date) {
        CalculusFieldElement h;
        CalculusFieldElement phi;
        FieldVector3D<T> pointInBodyFrame = frame == this.bodyFrame ? point : frame.getStaticTransformTo(this.bodyFrame, date).transformPosition(point);
        CalculusFieldElement r2 = (CalculusFieldElement)((CalculusFieldElement)pointInBodyFrame.getX().multiply((FieldElement)pointInBodyFrame.getX())).add((FieldElement)((CalculusFieldElement)pointInBodyFrame.getY().multiply((FieldElement)pointInBodyFrame.getY())));
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement z = pointInBodyFrame.getZ();
        CalculusFieldElement lambda = (CalculusFieldElement)pointInBodyFrame.getY().atan2((FieldElement)pointInBodyFrame.getX());
        if (r.getReal() <= 1.0E-4 * FastMath.abs((double)z.getReal())) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign((double)(this.getA() * this.e2 / this.g), (double)(-z.getReal()));
            CalculusFieldElement deltaZ = (CalculusFieldElement)z.subtract(evoluteCuspZ);
            phi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)deltaZ.abs()))).atan()).negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.getPi()).multiply(0.5)))).copySign((FieldElement)deltaZ);
            h = (CalculusFieldElement)((CalculusFieldElement)deltaZ.hypot((FieldElement)r)).subtract(osculatingRadius);
        } else if (FastMath.abs((double)z.getReal()) <= 1.0E-4 * r.getReal()) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            CalculusFieldElement deltaR = (CalculusFieldElement)r.subtract(evoluteCuspR);
            if (deltaR.getReal() >= 0.0) {
                phi = deltaR.getReal() == 0.0 ? (CalculusFieldElement)z.getField().getZero() : (CalculusFieldElement)((CalculusFieldElement)z.divide((FieldElement)deltaR)).atan();
                h = (CalculusFieldElement)((CalculusFieldElement)deltaR.hypot((FieldElement)z)).subtract(osculatingRadius);
            } else {
                CalculusFieldElement rClose = (CalculusFieldElement)r.divide(this.e2);
                CalculusFieldElement zClose = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rClose.multiply((FieldElement)rClose)).negate()).add(this.ae2)).sqrt()).multiply(this.g)).copySign((FieldElement)z);
                phi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zClose.subtract((FieldElement)z)).divide((FieldElement)((CalculusFieldElement)rClose.subtract((FieldElement)r)))).atan();
                h = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.subtract((FieldElement)rClose)).hypot((FieldElement)((CalculusFieldElement)z.subtract((FieldElement)zClose)))).negate();
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * this.getA();
            double c = this.getA() * this.e2;
            CalculusFieldElement absZ = (CalculusFieldElement)z.abs();
            CalculusFieldElement zc = (CalculusFieldElement)absZ.multiply(this.g);
            CalculusFieldElement sn = absZ;
            CalculusFieldElement sn2 = (CalculusFieldElement)sn.multiply((FieldElement)sn);
            CalculusFieldElement cn = (CalculusFieldElement)r.multiply(this.g);
            CalculusFieldElement cn2 = (CalculusFieldElement)cn.multiply((FieldElement)cn);
            CalculusFieldElement an2 = (CalculusFieldElement)cn2.add((FieldElement)sn2);
            CalculusFieldElement an = (CalculusFieldElement)an2.sqrt();
            CalculusFieldElement bn = (CalculusFieldElement)an.getField().getZero();
            phi = (CalculusFieldElement)((CalculusFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            h = (CalculusFieldElement)((CalculusFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            for (int i = 0; i < 1000; ++i) {
                CalculusFieldElement oldSn = sn;
                CalculusFieldElement oldCn = cn;
                CalculusFieldElement oldPhi = phi;
                CalculusFieldElement oldH = h;
                CalculusFieldElement an3 = (CalculusFieldElement)an2.multiply((FieldElement)an);
                CalculusFieldElement csncn = (CalculusFieldElement)((CalculusFieldElement)sn.multiply((FieldElement)cn)).multiply(c);
                bn = (CalculusFieldElement)((CalculusFieldElement)csncn.multiply(1.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)sn)).subtract((FieldElement)((CalculusFieldElement)zc.multiply((FieldElement)cn)))).multiply((FieldElement)an)).subtract((FieldElement)csncn)));
                sn = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zc.multiply((FieldElement)an3)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sn2.multiply((FieldElement)sn)).multiply(c)))).multiply((FieldElement)an3)).subtract((FieldElement)((CalculusFieldElement)bn.multiply((FieldElement)sn)));
                cn = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)an3)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cn2.multiply((FieldElement)cn)).multiply(c)))).multiply((FieldElement)an3)).subtract((FieldElement)((CalculusFieldElement)bn.multiply((FieldElement)cn)));
                if (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                    while (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                        sn = (CalculusFieldElement)((CalculusFieldElement)sn.add((FieldElement)oldSn)).multiply(0.5);
                        cn = (CalculusFieldElement)((CalculusFieldElement)cn.add((FieldElement)oldCn)).multiply(0.5);
                    }
                    continue;
                }
                int exp = (FastMath.getExponent((double)sn.getReal()) + FastMath.getExponent((double)cn.getReal())) / 2;
                sn = (CalculusFieldElement)sn.scalb(-exp);
                cn = (CalculusFieldElement)cn.scalb(-exp);
                sn2 = (CalculusFieldElement)sn.square();
                cn2 = (CalculusFieldElement)cn.square();
                an2 = (CalculusFieldElement)cn2.add((FieldElement)sn2);
                an = (CalculusFieldElement)an2.sqrt();
                CalculusFieldElement cc = (CalculusFieldElement)cn.multiply(this.g);
                h = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)cc)).add((FieldElement)((CalculusFieldElement)absZ.multiply((FieldElement)sn)))).subtract((FieldElement)((CalculusFieldElement)an.multiply(this.getA() * this.g)))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)an2.subtract((FieldElement)((CalculusFieldElement)cn2.multiply(this.e2)))).sqrt()));
                if (!(FastMath.abs((double)(oldH.getReal() - h.getReal())) < epsH)) continue;
                phi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sn.divide((FieldElement)cc)).atan()).copySign((FieldElement)z);
                if (FastMath.abs((double)(oldPhi.getReal() - phi.getReal())) < 1.0E-15) break;
            }
            if (Double.isInfinite(phi.getReal())) {
                phi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sn.divide((FieldElement)((CalculusFieldElement)cn.multiply(this.g)))).atan()).copySign((FieldElement)z);
            }
        }
        return new FieldGeodeticPoint<CalculusFieldElement>(phi, lambda, h);
    }

    public FieldGeodeticPoint<DerivativeStructure> transform(PVCoordinates point, Frame frame, AbsoluteDate date) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        PVCoordinates pointInBodyFrame = toBody.transformPVCoordinates(point);
        FieldVector3D<DerivativeStructure> p = pointInBodyFrame.toDerivativeStructureVector(2);
        DerivativeStructure pr2 = ((DerivativeStructure)p.getX()).square().add(((DerivativeStructure)p.getY()).square());
        DerivativeStructure pr = pr2.sqrt();
        DerivativeStructure pz = (DerivativeStructure)p.getZ();
        TimeStampedPVCoordinates groundPoint = this.projectToGround(new TimeStampedPVCoordinates(date, pointInBodyFrame), this.bodyFrame);
        FieldVector3D<DerivativeStructure> gp = groundPoint.toDerivativeStructureVector(2);
        DerivativeStructure gpr2 = ((DerivativeStructure)gp.getX()).square().add(((DerivativeStructure)gp.getY()).square());
        DerivativeStructure gpr = gpr2.sqrt();
        DerivativeStructure gpz = (DerivativeStructure)gp.getZ();
        DerivativeStructure dr = pr.subtract(gpr);
        DerivativeStructure dz = pz.subtract(gpz);
        double insideIfNegative = this.g2 * (pr2.getReal() - this.ae2) + pz.getReal() * pz.getReal();
        return new FieldGeodeticPoint<DerivativeStructure>(DerivativeStructure.atan2((DerivativeStructure)gpz, (DerivativeStructure)gpr.multiply(this.g2)), DerivativeStructure.atan2((DerivativeStructure)((DerivativeStructure)p.getY()), (DerivativeStructure)((DerivativeStructure)p.getX())), DerivativeStructure.hypot((DerivativeStructure)dr, (DerivativeStructure)dz).copySign(insideIfNegative));
    }

    public double azimuthBetweenPoints(GeodeticPoint origin, GeodeticPoint destination) {
        double dLon = MathUtils.normalizeAngle((double)destination.getLongitude(), (double)origin.getLongitude()) - origin.getLongitude();
        double originIsoLat = this.geodeticToIsometricLatitude(origin.getLatitude());
        double destIsoLat = this.geodeticToIsometricLatitude(destination.getLatitude());
        double az = FastMath.atan2((double)dLon, (double)(destIsoLat - originIsoLat));
        if (az < 0.0) {
            return az + Math.PI * 2;
        }
        return az;
    }

    public <T extends CalculusFieldElement<T>> T azimuthBetweenPoints(FieldGeodeticPoint<T> origin, FieldGeodeticPoint<T> destination) {
        CalculusFieldElement dLon = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)destination.getLongitude().subtract(origin.getLongitude())), (CalculusFieldElement)((CalculusFieldElement)origin.getLongitude().getField().getZero()));
        T originIsoLat = this.geodeticToIsometricLatitude(origin.getLatitude());
        T destIsoLat = this.geodeticToIsometricLatitude(destination.getLatitude());
        CalculusFieldElement az = FastMath.atan2((CalculusFieldElement)dLon, (CalculusFieldElement)((CalculusFieldElement)destIsoLat.subtract(originIsoLat)));
        if (az.getReal() < 0.0) {
            return (T)((CalculusFieldElement)az.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)az.getPi()).multiply(2))));
        }
        return (T)az;
    }

    public double geodeticToIsometricLatitude(double geodeticLatitude) {
        if (FastMath.abs((double)geodeticLatitude) <= this.angularThreshold) {
            return 0.0;
        }
        double eSinLat = this.e * FastMath.sin((double)geodeticLatitude);
        double a = FastMath.log((double)FastMath.tan((double)(0.7853981633974483 + geodeticLatitude / 2.0)));
        double b = this.e / 2.0 * FastMath.log((double)((1.0 - eSinLat) / (1.0 + eSinLat)));
        return a + b;
    }

    public <T extends CalculusFieldElement<T>> T geodeticToIsometricLatitude(T geodeticLatitude) {
        if (((CalculusFieldElement)geodeticLatitude.abs()).getReal() <= this.angularThreshold) {
            return (T)((CalculusFieldElement)geodeticLatitude.getField().getZero());
        }
        Field field = geodeticLatitude.getField();
        CalculusFieldElement ecc = (CalculusFieldElement)geodeticLatitude.newInstance(this.e);
        CalculusFieldElement eSinLat = (CalculusFieldElement)ecc.multiply((FieldElement)((CalculusFieldElement)geodeticLatitude.sin()));
        CalculusFieldElement a = FastMath.log((CalculusFieldElement)FastMath.tan((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)geodeticLatitude.getPi()).divide(4.0)).add((FieldElement)((CalculusFieldElement)geodeticLatitude.divide(2.0))))));
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)ecc.divide(2.0)).multiply((FieldElement)FastMath.log((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getOne()).subtract((FieldElement)eSinLat)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getOne()).add((FieldElement)eSinLat))))));
        return (T)((CalculusFieldElement)a.add((FieldElement)b));
    }

    public GeodeticPoint lowestAltitudeIntermediate(Vector3D endpoint1, Vector3D endpoint2) {
        DoubleFunction<GeodeticPoint> intermediate;
        GeodeticPoint gp1;
        Vector3D delta = endpoint2.subtract((Vector)endpoint1);
        if (Vector3D.dotProduct((Vector3D)delta, (Vector3D)(gp1 = (intermediate = lambda -> this.transform(new Vector3D(1.0 - lambda, endpoint1, lambda, endpoint2), this.bodyFrame, null)).apply(0.0)).getZenith()) >= 0.0) {
            return gp1;
        }
        GeodeticPoint gp2 = intermediate.apply(1.0);
        if (Vector3D.dotProduct((Vector3D)delta, (Vector3D)gp2.getZenith()) <= 0.0) {
            return gp2;
        }
        double lambdaMin = new BracketingNthOrderBrentSolver(1.0E-14, 5).solve(1000, lambda -> Vector3D.dotProduct((Vector3D)delta, (Vector3D)((GeodeticPoint)intermediate.apply(lambda)).getZenith()), 0.0, 1.0);
        return intermediate.apply(lambdaMin);
    }

    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> lowestAltitudeIntermediate(FieldVector3D<T> endpoint1, FieldVector3D<T> endpoint2) {
        DoubleFunction<FieldGeodeticPoint> intermediate;
        FieldGeodeticPoint gp1;
        FieldVector3D delta = endpoint2.subtract(endpoint1);
        if (FieldVector3D.dotProduct((FieldVector3D)delta, (gp1 = (intermediate = lambda -> this.transform(new FieldVector3D(1.0 - lambda, endpoint1, lambda, endpoint2), this.bodyFrame, null)).apply(0.0)).getZenith()).getReal() >= 0.0) {
            return gp1;
        }
        FieldGeodeticPoint gp2 = intermediate.apply(1.0);
        if (FieldVector3D.dotProduct((FieldVector3D)delta, gp2.getZenith()).getReal() <= 0.0) {
            return gp2;
        }
        double lambdaMin = new BracketingNthOrderBrentSolver(1.0E-14, 5).solve(1000, lambda -> FieldVector3D.dotProduct((FieldVector3D)delta, ((FieldGeodeticPoint)intermediate.apply(lambda)).getZenith()).getReal(), 0.0, 1.0);
        return intermediate.apply(lambdaMin);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.getA(), this.f, this.bodyFrame, this.angularThreshold);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20130518L;
        private final double ae;
        private final double f;
        private final Frame bodyFrame;
        private final double angularThreshold;

        DataTransferObject(double ae, double f, Frame bodyFrame, double angularThreshold) {
            this.ae = ae;
            this.f = f;
            this.bodyFrame = bodyFrame;
            this.angularThreshold = angularThreshold;
        }

        private Object readResolve() {
            OneAxisEllipsoid ellipsoid = new OneAxisEllipsoid(this.ae, this.f, this.bodyFrame);
            ellipsoid.setAngularThreshold(this.angularThreshold);
            return ellipsoid;
        }
    }
}

